/*
 * Decompiled with CFR 0.152.
 */
package boofcv.simulation;

import boofcv.abst.tracker.PointTrack;
import boofcv.abst.tracker.PointTracker;
import boofcv.alg.distort.brown.LensDistortionBrown;
import boofcv.alg.distort.pinhole.LensDistortionPinhole;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import gnu.trove.map.TIntLongMap;
import gnu.trove.map.TLongIntMap;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TIntLongHashMap;
import gnu.trove.map.hash.TLongIntHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I64;
import org.jetbrains.annotations.Nullable;

public class PointTrackerPerfectCloud<T extends ImageBase<T>>
implements PointTracker<T> {
    public List<Point3D_F64> cloud = new ArrayList<Point3D_F64>();
    public Se3_F64 world_to_view = new Se3_F64();
    public Point2Transform2_F64 norm_to_pixel;
    public int width;
    public int height;
    public int frameID;
    private final Point3D_F64 viewX = new Point3D_F64();
    private final Point2D_F64 pixel = new Point2D_F64();
    private final List<PointTrack> dropped = new ArrayList<PointTrack>();
    private final List<PointTrack> spawned = new ArrayList<PointTrack>();
    private final DogArray<Spawnable> spawnable = new DogArray(Spawnable::new);
    private final DogArray<PointTrack> activeTracks = new DogArray(PointTrack::new, PointTrack::reset);
    private final TIntLongMap cloudIdx_to_id = new TIntLongHashMap();
    private final TLongIntMap id_to_cloudIdx = new TLongIntHashMap();
    private final TLongObjectMap<PointTrack> id_to_track = new TLongObjectHashMap();
    private final TLongSet observedID = new TLongHashSet();
    private long totalTracks = 0L;

    public PointTrackerPerfectCloud() {
        this.reset();
    }

    public void process(T image) {
        Objects.requireNonNull(this.norm_to_pixel, "You must set norm_to_pixel first");
        BoofMiscOps.checkTrue((this.width != 0 && this.height != 0 ? 1 : 0) != 0, (String)"You must specify width and height");
        ++this.frameID;
        this.observedID.clear();
        this.dropped.clear();
        this.spawned.clear();
        this.spawnable.reset();
        for (int cloudIdx = 0; cloudIdx < this.cloud.size(); ++cloudIdx) {
            Point3D_F64 X = this.cloud.get(cloudIdx);
            this.world_to_view.transform(X, this.viewX);
            if (this.viewX.z <= 0.0) continue;
            this.norm_to_pixel.compute(this.viewX.x / this.viewX.z, this.viewX.y / this.viewX.z, this.pixel);
            if (!BoofMiscOps.isInside((int)this.width, (int)this.height, (double)this.pixel.x, (double)this.pixel.y)) continue;
            if (this.cloudIdx_to_id.containsKey(cloudIdx)) {
                long id = this.cloudIdx_to_id.get(cloudIdx);
                PointTrack track = (PointTrack)this.id_to_track.get(id);
                BoofMiscOps.checkTrue((boolean)this.observedID.add(id));
                track.pixel.setTo((GeoTuple2D_F64)this.pixel);
                track.lastSeenFrameID = this.frameID;
                continue;
            }
            ((Spawnable)this.spawnable.grow()).setTo(cloudIdx, this.pixel);
        }
        this.dropUnobserved();
    }

    void dropUnobserved() {
        DogArray_I64 dropList = new DogArray_I64();
        for (long id2 : this.id_to_track.keys()) {
            if (this.observedID.contains(id2)) continue;
            dropList.add(id2);
        }
        dropList.forEach(id -> {
            PointTrack track = Objects.requireNonNull((PointTrack)this.id_to_track.remove(id));
            this.dropped.add(track);
            BoofMiscOps.checkTrue((boolean)this.activeTracks.remove((Object)track));
            int cloudIdx = this.id_to_cloudIdx.remove(id);
            this.cloudIdx_to_id.remove(cloudIdx);
        });
    }

    public void reset() {
        this.frameID = -1;
        this.totalTracks = 0L;
        this.activeTracks.reset();
        this.cloudIdx_to_id.clear();
        this.id_to_track.clear();
        this.observedID.clear();
    }

    public long getFrameID() {
        return this.frameID;
    }

    public int getTotalActive() {
        return this.activeTracks.size;
    }

    public int getTotalInactive() {
        return 0;
    }

    public void dropAllTracks() {
        this.activeTracks.reset();
        this.cloudIdx_to_id.clear();
        this.id_to_cloudIdx.clear();
        this.id_to_track.clear();
    }

    public int getMaxSpawn() {
        return 0;
    }

    public boolean dropTrack(PointTrack track) {
        for (long id : this.id_to_track.keys()) {
            if (this.id_to_track.get(id) != track) continue;
            this.id_to_track.remove(id);
            this.cloudIdx_to_id.remove(this.id_to_cloudIdx.get(id));
            this.id_to_cloudIdx.remove(id);
            int index = this.activeTracks.indexOf((Object)track);
            BoofMiscOps.checkTrue((index != -1 ? 1 : 0) != 0, (String)"BUG! Track in map but not array");
            this.activeTracks.removeSwap(index);
            return true;
        }
        return false;
    }

    public void dropTracks(PointTracker.Dropper dropper) {
        throw new RuntimeException("Implement when needed");
    }

    public List<PointTrack> getAllTracks(@Nullable List<PointTrack> list) {
        return this.getActiveTracks(list);
    }

    public List<PointTrack> getActiveTracks(@Nullable List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        }
        list.clear();
        list.addAll(this.activeTracks.toList());
        return list;
    }

    public List<PointTrack> getInactiveTracks(@Nullable List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        }
        list.clear();
        return list;
    }

    public List<PointTrack> getDroppedTracks(@Nullable List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        }
        list.clear();
        list.addAll(this.dropped);
        return list;
    }

    public List<PointTrack> getNewTracks(@Nullable List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        }
        list.clear();
        list.addAll(this.spawned);
        return list;
    }

    public void spawnTracks() {
        this.spawnable.forEach(spawn -> {
            long id = this.totalTracks++;
            this.cloudIdx_to_id.put(spawn.cloudIdx, id);
            PointTrack track = (PointTrack)this.activeTracks.grow();
            track.featureId = id;
            track.detectorSetId = 0;
            track.spawnFrameID = this.frameID;
            track.lastSeenFrameID = this.frameID;
            track.pixel.setTo((GeoTuple2D_F64)spawn.pixel);
            this.id_to_track.put(id, (Object)track);
            this.spawned.add(track);
        });
    }

    public ImageType<T> getImageType() {
        throw new IllegalArgumentException("Not implemented");
    }

    public void setCamera(CameraPinhole intrinsic) {
        this.norm_to_pixel = new LensDistortionPinhole(intrinsic).distort_F64(false, true);
        this.width = intrinsic.width;
        this.height = intrinsic.height;
    }

    public void setCamera(CameraPinholeBrown intrinsic) {
        this.norm_to_pixel = new LensDistortionBrown(intrinsic).distort_F64(false, true);
        this.width = intrinsic.width;
        this.height = intrinsic.height;
    }

    static class Spawnable {
        public int cloudIdx;
        public Point2D_F64 pixel = new Point2D_F64();

        Spawnable() {
        }

        public void setTo(int cloudIdx, Point2D_F64 pixel) {
            this.cloudIdx = cloudIdx;
            this.pixel.setTo((GeoTuple2D_F64)pixel);
        }
    }
}

