/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.fiducial;

import boofcv.abst.fiducial.calib.CalibrationDetectorChessboardBinary;
import boofcv.abst.fiducial.calib.CalibrationDetectorChessboardX;
import boofcv.abst.fiducial.calib.CalibrationDetectorCircleHexagonalGrid;
import boofcv.abst.fiducial.calib.CalibrationDetectorCircleRegularGrid;
import boofcv.abst.fiducial.calib.CalibrationDetectorMultiECoCheck;
import boofcv.abst.fiducial.calib.CalibrationDetectorSquareGrid;
import boofcv.abst.fiducial.calib.ConfigChessboardBinary;
import boofcv.abst.fiducial.calib.ConfigChessboardX;
import boofcv.abst.fiducial.calib.ConfigCircleHexagonalGrid;
import boofcv.abst.fiducial.calib.ConfigCircleRegularGrid;
import boofcv.abst.fiducial.calib.ConfigECoCheckDetector;
import boofcv.abst.fiducial.calib.ConfigECoCheckMarkers;
import boofcv.abst.fiducial.calib.ConfigGridDimen;
import boofcv.abst.fiducial.calib.ConfigSquareGrid;
import boofcv.abst.geo.calibration.DetectMultiFiducialCalibration;
import boofcv.abst.geo.calibration.DetectSingleFiducialCalibration;
import boofcv.abst.geo.calibration.MultiToSingleFiducialCalibration;
import boofcv.alg.fiducial.calib.ConfigCalibrationTarget;
import boofcv.alg.fiducial.calib.ecocheck.ECoCheckDetector;
import boofcv.factory.fiducial.FactoryFiducial;
import boofcv.struct.image.GrayF32;
import org.jetbrains.annotations.Nullable;

public class FactoryFiducialCalibration {
    public static DetectSingleFiducialCalibration genericSingle(ConfigCalibrationTarget config) {
        Object object;
        switch (config.type) {
            case CHESSBOARD: {
                object = FactoryFiducialCalibration.chessboardX(null, config.grid);
                break;
            }
            case ECOCHECK: {
                object = new MultiToSingleFiducialCalibration((DetectMultiFiducialCalibration)FactoryFiducialCalibration.ecocheck(null, config.ecocheck));
                break;
            }
            case SQUARE_GRID: {
                object = FactoryFiducialCalibration.squareGrid(null, config.grid);
                break;
            }
            case CIRCLE_GRID: {
                object = FactoryFiducialCalibration.circleRegularGrid(null, config.grid);
                break;
            }
            case CIRCLE_HEXAGONAL: {
                object = FactoryFiducialCalibration.circleHexagonalGrid(null, config.grid);
                break;
            }
            default: {
                throw new RuntimeException("Target type not yet supported.");
            }
        }
        return object;
    }

    public static CalibrationDetectorSquareGrid squareGrid(@Nullable ConfigSquareGrid config, ConfigGridDimen configDimen) {
        if (config == null) {
            config = new ConfigSquareGrid();
        }
        config.checkValidity();
        return new CalibrationDetectorSquareGrid(config, configDimen);
    }

    public static CalibrationDetectorChessboardBinary chessboardB(@Nullable ConfigChessboardBinary configDet, ConfigGridDimen configGrid) {
        if (configDet == null) {
            configDet = new ConfigChessboardBinary();
        }
        configDet.checkValidity();
        return new CalibrationDetectorChessboardBinary(configDet, configGrid);
    }

    public static CalibrationDetectorChessboardX chessboardX(@Nullable ConfigChessboardX config, ConfigGridDimen dimen) {
        if (config == null) {
            config = new ConfigChessboardX();
        }
        config.checkValidity();
        return new CalibrationDetectorChessboardX(config, dimen);
    }

    public static CalibrationDetectorMultiECoCheck ecocheck(@Nullable ConfigECoCheckDetector configDetector, ConfigECoCheckMarkers configMarkers) {
        ECoCheckDetector<GrayF32> detector = FactoryFiducial.ecocheck(configDetector, configMarkers, GrayF32.class).getDetector();
        return new CalibrationDetectorMultiECoCheck(detector, configMarkers.firstTargetDuplicated, configMarkers.markerShapes.toList());
    }

    public static CalibrationDetectorCircleHexagonalGrid circleHexagonalGrid(@Nullable ConfigCircleHexagonalGrid config, ConfigGridDimen configGrid) {
        if (config == null) {
            config = new ConfigCircleHexagonalGrid();
        }
        config.checkValidity();
        return new CalibrationDetectorCircleHexagonalGrid(config, configGrid);
    }

    public static CalibrationDetectorCircleRegularGrid circleRegularGrid(@Nullable ConfigCircleRegularGrid config, ConfigGridDimen configGrid) {
        if (config == null) {
            config = new ConfigCircleRegularGrid();
        }
        config.checkValidity();
        return new CalibrationDetectorCircleRegularGrid(config, configGrid);
    }
}

