/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

import boofcv.alg.fiducial.qrcode.PackedBits;
import java.util.Arrays;

public class PackedBits32
implements PackedBits {
    public int[] data = new int[1];
    public int size;

    public PackedBits32(int totalBits) {
        this.resize(totalBits);
    }

    public PackedBits32() {
    }

    public void setTo(PackedBits32 src) {
        this.resize(src.size);
        System.arraycopy(src.data, 0, this.data, 0, src.arrayLength());
    }

    @Override
    public int get(int which) {
        int index = which / 32;
        int offset = which % 32;
        return this.data[index] >>> offset & 1;
    }

    @Override
    public void set(int which, int value) {
        int index = which / 32;
        int offset = which % 32;
        int n = index;
        this.data[n] = this.data[n] ^ (-value ^ this.data[index]) & 1 << offset;
    }

    @Override
    public void resize(int totalBits) {
        this.size = totalBits;
        int N = totalBits / 32 + (totalBits % 32 > 0 ? 1 : 0);
        if (this.data.length < N) {
            this.data = new int[N];
        }
    }

    @Override
    public void zero() {
        int N = this.size / 32;
        Arrays.fill(this.data, 0, N, 0);
    }

    @Override
    public int length() {
        return this.size;
    }

    @Override
    public int arrayLength() {
        return this.size / 32 + (this.size % 32 > 0 ? 1 : 0);
    }

    @Override
    public int elementBits() {
        return 32;
    }
}

