/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.ecocheck;

import boofcv.alg.drawing.FiducialRenderEngine;
import boofcv.alg.fiducial.calib.ecocheck.ECoCheckUtils;
import boofcv.alg.fiducial.qrcode.PackedBits8;
import boofcv.struct.GridShape;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Rectangle2D_F64;
import java.util.ArrayList;
import java.util.List;

public class ECoCheckGenerator {
    public double squareWidth = 1.0;
    final ECoCheckUtils utils;
    protected FiducialRenderEngine render;
    PackedBits8 packetBits = new PackedBits8();
    Rectangle2D_F64 rect = new Rectangle2D_F64();
    public final List<Point2D_F64> corners = new ArrayList<Point2D_F64>();

    public ECoCheckGenerator(ECoCheckUtils utils) {
        this.utils = utils;
        utils.checkFixate();
    }

    public void render(int marker) {
        this.corners.clear();
        GridShape shape = this.utils.markers.get(marker);
        this.render.init();
        this.renderSquares(shape);
        this.renderCodes(marker, shape);
        this.saveCornerLocations(shape);
    }

    private void renderSquares(GridShape shape) {
        int rows = shape.rows;
        int cols = shape.cols;
        this.render.setGray(0.0);
        double stub = this.squareWidth / 2.0;
        for (int col = 0; col < cols; ++col) {
            boolean borderCol = col == 0 || col == cols - 1;
            double x = col == 0 ? 0.0 : stub + this.squareWidth * (double)(col - 1);
            double lengthX = borderCol ? stub : this.squareWidth;
            for (int row = col % 2; row < rows; row += 2) {
                boolean borderRow = row == 0 || row == rows - 1;
                double lengthY = borderRow ? stub : this.squareWidth;
                double y = row == 0 ? 0.0 : stub + this.squareWidth * (double)(row - 1);
                this.render.rectangle(x, y, x + lengthX, y + lengthY);
            }
        }
    }

    private void renderCodes(int marker, GridShape shape) {
        int rows = shape.rows;
        int cols = shape.cols;
        this.render.setGray(0.0);
        double stub = this.squareWidth / 2.0;
        int cellID = 0;
        for (int row = 1; row < rows; ++row) {
            boolean borderRow = row == rows - 1;
            double y = stub + this.squareWidth * (double)(row - 1);
            for (int col = 1 + row % 2; col < cols; col += 2) {
                boolean borderCol = col == cols - 1;
                double x = stub + this.squareWidth * (double)(col - 1);
                if (borderCol || borderRow) continue;
                this.utils.codec.encode(marker, cellID++, this.packetBits);
                this.renderEncoding(x, y);
            }
        }
    }

    public void saveCornerLocations(GridShape shape) {
        this.corners.clear();
        int rows = shape.rows;
        int cols = shape.cols;
        double stub = this.squareWidth / 2.0;
        for (int row = 1; row < rows; ++row) {
            double y = stub + this.squareWidth * (double)(row - 1);
            for (int col = 1; col < cols; ++col) {
                double x = stub + this.squareWidth * (double)(col - 1);
                this.corners.add(new Point2D_F64(x, y));
            }
        }
    }

    private void renderEncoding(double px, double py) {
        int dotGridSize = this.utils.codec.getGridBitLength();
        for (int row = 0; row < dotGridSize; ++row) {
            for (int col = 0; col < dotGridSize; ++col) {
                int bit = this.utils.bitOrder.get(row * dotGridSize + col);
                if (this.packetBits.get(bit) == 0) continue;
                this.utils.bitRect(row, col, this.rect);
                this.render.square(px + this.rect.p0.x * this.squareWidth, py + this.rect.p0.y * this.squareWidth, this.rect.getWidth() * this.squareWidth);
            }
        }
    }

    public void setSquareWidth(double squareWidth) {
        this.squareWidth = squareWidth;
    }

    public double getSquareWidth() {
        return this.squareWidth;
    }

    public void setRender(FiducialRenderEngine render) {
        this.render = render;
    }
}

