/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.tracker;

import boofcv.abst.tracker.TrackerObjectQuad;
import boofcv.alg.tracker.tld.TldTracker;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.geometry.UtilPolygons2D_F64;
import georegression.struct.shapes.Quadrilateral_F64;
import georegression.struct.shapes.Rectangle2D_F64;

public class Tld_to_TrackerObjectQuad<T extends ImageGray<T>, D extends ImageGray<D>>
implements TrackerObjectQuad<T> {
    Rectangle2D_F64 rect = new Rectangle2D_F64();
    TldTracker<T, D> tracker;
    ImageType<T> type;

    public Tld_to_TrackerObjectQuad(TldTracker<T, D> tracker, Class<T> imageType) {
        this.tracker = tracker;
        this.type = ImageType.single(imageType);
    }

    @Override
    public boolean initialize(T image, Quadrilateral_F64 location) {
        UtilPolygons2D_F64.bounding((Quadrilateral_F64)location, (Rectangle2D_F64)this.rect);
        this.tracker.initialize(image, (int)this.rect.p0.x, (int)this.rect.p0.y, (int)this.rect.p1.x, (int)this.rect.p1.y);
        return true;
    }

    @Override
    public void hint(Quadrilateral_F64 hint) {
        UtilPolygons2D_F64.bounding((Quadrilateral_F64)hint, (Rectangle2D_F64)this.rect);
        this.tracker.setTrackerLocation((int)this.rect.p0.x, (int)this.rect.p0.y, (int)this.rect.p1.x, (int)this.rect.p1.y);
    }

    @Override
    public boolean process(T image, Quadrilateral_F64 results) {
        if (!this.tracker.track(image)) {
            return false;
        }
        Rectangle2D_F64 rect = this.tracker.getTargetRegion();
        results.a.x = rect.p0.x;
        results.a.y = rect.p0.y;
        results.b.x = rect.p1.x;
        results.b.y = rect.p0.y;
        results.c.x = rect.p1.x;
        results.c.y = rect.p1.y;
        results.d.x = rect.p0.x;
        results.d.y = rect.p1.y;
        return true;
    }

    @Override
    public ImageType<T> getImageType() {
        return this.type;
    }

    @Override
    public TldTracker<T, D> getLowLevelTracker() {
        return this.tracker;
    }
}

