/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.scene.ann;

import boofcv.abst.scene.FeatureSceneRecognition;
import boofcv.abst.scene.SceneRecognition;
import boofcv.abst.scene.ann.ConfigRecognitionNearestNeighbor;
import boofcv.alg.scene.ann.RecognitionNearestNeighborInvertedFile;
import boofcv.alg.scene.bow.BowMatch;
import boofcv.factory.feature.associate.FactoryAssociation;
import boofcv.factory.struct.FactoryTupleDesc;
import boofcv.misc.BoofLambdas;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.feature.PackedTupleArray;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.kmeans.FactoryTupleCluster;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.ddogleg.clustering.kmeans.StandardKMeans;
import org.ddogleg.nn.ConfigNearestNeighborSearch;
import org.ddogleg.nn.FactoryNearestNeighbor;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.alg.KdTreeDistance;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.Factory;
import org.ddogleg.struct.LArrayAccessor;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public class FeatureSceneRecognitionNearestNeighbor<TD extends TupleDesc<TD>>
implements FeatureSceneRecognition<TD> {
    ConfigRecognitionNearestNeighbor config;
    NearestNeighbor<TD> nearestNeighbor;
    RecognitionNearestNeighborInvertedFile<TD> database;
    List<TD> dictionary = new ArrayList<TD>();
    DogArray<TD> imageFeatures;
    List<String> imageIds = new ArrayList<String>();
    public int minimumForThread = 500;
    long timeLearnDescribeMS;
    long timeLearnClusterMS;
    Class<TD> tupleType;
    int tupleDOF;
    @Nullable
    PrintStream verbose;

    public FeatureSceneRecognitionNearestNeighbor(ConfigRecognitionNearestNeighbor config, Factory<TD> factory) {
        this.config = config;
        this.imageFeatures = new DogArray(factory);
        this.database = new RecognitionNearestNeighborInvertedFile();
        this.database.setDistanceType(config.distanceNorm);
        this.tupleDOF = ((TupleDesc)this.imageFeatures.grow()).size();
        this.tupleType = ((TupleDesc)this.imageFeatures.get(0)).getClass();
    }

    @Override
    public void learnModel(Iterator<FeatureSceneRecognition.Features<TD>> images) {
        PackedTupleArray packedFeatures = FactoryTupleDesc.createPackedBig((int)this.tupleDOF, this.tupleType);
        DogArray_I32 startIndex = new DogArray_I32();
        long time0 = System.currentTimeMillis();
        while (images.hasNext()) {
            FeatureSceneRecognition.Features<TD> image = images.next();
            startIndex.add(packedFeatures.size());
            int N = image.size();
            packedFeatures.reserve(N);
            for (int i = 0; i < N; ++i) {
                packedFeatures.append(image.getDescription(i));
            }
            if (this.verbose == null) continue;
            this.verbose.println("described.size=" + startIndex.size + " features=" + N + " packed.size=" + packedFeatures.size());
        }
        startIndex.add(packedFeatures.size());
        if (this.verbose != null) {
            this.verbose.println("packedFeatures.size=" + packedFeatures.size());
        }
        long time1 = System.currentTimeMillis();
        this.timeLearnDescribeMS = time1 - time0;
        StandardKMeans<TD> clustering = FactoryTupleCluster.kmeans(this.config.kmeans, this.minimumForThread, this.tupleDOF, this.tupleType);
        if (this.verbose != null) {
            clustering.setVerbose(true);
        }
        clustering.initialize(this.config.randSeed);
        clustering.process((LArrayAccessor)packedFeatures, this.config.numberOfWords);
        long time2 = System.currentTimeMillis();
        this.timeLearnClusterMS = time2 - time1;
        this.setDictionary(clustering.getBestClusters().toList());
    }

    @Override
    public void clearDatabase() {
        this.imageIds.clear();
        this.database.clearImages();
    }

    @Override
    public void addImage(String id, FeatureSceneRecognition.Features<TD> features) {
        this.imageFeatures.resize(features.size());
        for (int i = 0; i < this.imageFeatures.size; ++i) {
            ((TupleDesc)this.imageFeatures.get(i)).setTo(features.getDescription(i));
        }
        int imageIndex = this.imageIds.size();
        this.imageIds.add(id);
        if (this.verbose != null) {
            this.verbose.println("added[" + imageIndex + "].size=" + features.size() + " id=" + id);
        }
        this.database.addImage(imageIndex, this.imageFeatures.toList());
    }

    @Override
    public List<String> getImageIds(@Nullable List<String> storage) {
        if (storage == null) {
            storage = new ArrayList<String>();
        } else {
            storage.clear();
        }
        storage.addAll(this.imageIds);
        return storage;
    }

    @Override
    public boolean query(FeatureSceneRecognition.Features<TD> query, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable BoofLambdas.Filter<String> filter, int limit, DogArray<SceneRecognition.Match> matches) {
        BoofLambdas.FilterInt filterInt;
        matches.resize(0);
        limit = limit <= 0 ? Integer.MAX_VALUE : limit;
        this.imageFeatures.resize(query.size());
        for (int i = 0; i < this.imageFeatures.size; ++i) {
            ((TupleDesc)this.imageFeatures.get(i)).setTo(query.getDescription(i));
        }
        BoofLambdas.FilterInt filterInt2 = filterInt = filter == null ? null : index -> filter.keep((Object)this.imageIds.get(index));
        if (!this.database.query(this.imageFeatures.toList(), filterInt, limit)) {
            return false;
        }
        DogArray<BowMatch> found = this.database.getMatches();
        if (this.verbose != null) {
            this.verbose.println("matches.size=" + found.size + " best.error=" + ((BowMatch)found.get((int)0)).error);
        }
        matches.resize(found.size);
        for (int i = 0; i < matches.size; ++i) {
            BowMatch f = (BowMatch)found.get(i);
            ((SceneRecognition.Match)matches.get((int)i)).id = this.imageIds.get(f.identification);
            ((SceneRecognition.Match)matches.get((int)i)).error = f.error;
        }
        return !matches.isEmpty();
    }

    public void setDictionary(List<TD> dictionary) {
        this.clearDatabase();
        this.dictionary = dictionary;
        NearestNeighbor nearestNeighbor = FactoryNearestNeighbor.generic((ConfigNearestNeighborSearch)this.config.nearestNeighbor, (KdTreeDistance)FactoryAssociation.kdtreeDistance((int)this.tupleDOF, this.tupleType));
        nearestNeighbor.setPoints(dictionary, true);
        this.database.initialize(nearestNeighbor, dictionary.size());
    }

    @Override
    public int getQueryWord(int featureIdx) {
        return this.database.observedWords.get(featureIdx);
    }

    @Override
    public void getQueryWords(int featureIdx, DogArray_I32 words) {
        words.reset();
        words.add(this.database.observedWords.get(featureIdx));
    }

    @Override
    public int lookupWord(TD description) {
        this.database.search.findNearest(description, -1.0, this.database.searchResult);
        return this.database.searchResult.index;
    }

    @Override
    public void lookupWords(TD description, DogArray_I32 words) {
        words.reset();
        words.add(this.lookupWord(description));
    }

    @Override
    public int getTotalWords() {
        return this.config.numberOfWords;
    }

    @Override
    public Class<TD> getDescriptorType() {
        return this.tupleType;
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> config) {
        this.verbose = BoofMiscOps.addPrefix((VerbosePrint)this, (PrintStream)out);
    }

    public ConfigRecognitionNearestNeighbor getConfig() {
        return this.config;
    }

    public NearestNeighbor<TD> getNearestNeighbor() {
        return this.nearestNeighbor;
    }

    public RecognitionNearestNeighborInvertedFile<TD> getDatabase() {
        return this.database;
    }

    public List<TD> getDictionary() {
        return this.dictionary;
    }

    public DogArray<TD> getImageFeatures() {
        return this.imageFeatures;
    }

    public void setImageFeatures(DogArray<TD> imageFeatures) {
        this.imageFeatures = imageFeatures;
    }

    public List<String> getImageIds() {
        return this.imageIds;
    }

    public int getMinimumForThread() {
        return this.minimumForThread;
    }

    public void setMinimumForThread(int minimumForThread) {
        this.minimumForThread = minimumForThread;
    }

    public long getTimeLearnDescribeMS() {
        return this.timeLearnDescribeMS;
    }

    public long getTimeLearnClusterMS() {
        return this.timeLearnClusterMS;
    }

    public Class<TD> getTupleType() {
        return this.tupleType;
    }

    public int getTupleDOF() {
        return this.tupleDOF;
    }
}

