/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.template;

import boofcv.alg.template.TemplateIntensityImage;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import java.util.Objects;
import org.ejml.UtilEjml;
import org.jetbrains.annotations.Nullable;

public abstract class TemplateSqDiffNormed<T extends ImageBase<T>>
implements TemplateIntensityImage.EvaluatorMethod<T> {
    float EPS = UtilEjml.F_EPS;
    TemplateIntensityImage<T> o;

    @Override
    public void initialize(TemplateIntensityImage<T> owner) {
        this.o = owner;
        this.setupTemplate(this.o.template, this.o.mask);
    }

    @Override
    public boolean isMaximize() {
        return true;
    }

    public abstract void setupTemplate(T var1, @Nullable T var2);

    @Override
    public boolean isBorderProcessed() {
        return false;
    }

    public static class U8
    extends TemplateSqDiffNormed<GrayU8> {
        double area;
        double templateSumSq;

        @Override
        public float evaluate(int tl_x, int tl_y) {
            double imageSumSq = 0.0;
            for (int y = 0; y < ((GrayU8)this.o.template).height; ++y) {
                int imageIndex = ((GrayU8)this.o.image).startIndex + (tl_y + y) * ((GrayU8)this.o.image).stride + tl_x;
                for (int x = 0; x < ((GrayU8)this.o.template).width; ++x) {
                    double v = ((GrayU8)this.o.image).data[imageIndex++] & 0xFF;
                    imageSumSq += v * v;
                }
            }
            imageSumSq /= this.area;
            double errorSumSq = 0.0;
            for (int y = 0; y < ((GrayU8)this.o.template).height; ++y) {
                int imageIndex = ((GrayU8)this.o.image).startIndex + (tl_y + y) * ((GrayU8)this.o.image).stride + tl_x;
                int templateIndex = ((GrayU8)this.o.template).startIndex + y * ((GrayU8)this.o.template).stride;
                for (int x = 0; x < ((GrayU8)this.o.template).width; ++x) {
                    double error = (((GrayU8)this.o.image).data[imageIndex++] & 0xFF) - (((GrayU8)this.o.template).data[templateIndex++] & 0xFF);
                    errorSumSq += error * error;
                }
            }
            return (float)(-(errorSumSq /= this.area) / Math.sqrt((double)this.EPS + this.templateSumSq * imageSumSq));
        }

        @Override
        public float evaluateMask(int tl_x, int tl_y) {
            Objects.requireNonNull((GrayU8)this.o.mask);
            double imageSumSq = 0.0;
            for (int y = 0; y < ((GrayU8)this.o.template).height; ++y) {
                int imageIndex = ((GrayU8)this.o.image).startIndex + (tl_y + y) * ((GrayU8)this.o.image).stride + tl_x;
                int maskIndex = ((GrayU8)this.o.mask).startIndex + y * ((GrayU8)this.o.mask).stride;
                for (int x = 0; x < ((GrayU8)this.o.template).width; ++x) {
                    double v = (((GrayU8)this.o.image).data[imageIndex++] & 0xFF) * (((GrayU8)this.o.mask).data[maskIndex++] & 0xFF);
                    imageSumSq += v * v;
                }
            }
            imageSumSq /= this.area;
            double errorSumSq = 0.0;
            for (int y = 0; y < ((GrayU8)this.o.template).height; ++y) {
                int imageIndex = ((GrayU8)this.o.image).startIndex + (tl_y + y) * ((GrayU8)this.o.image).stride + tl_x;
                int templateIndex = ((GrayU8)this.o.template).startIndex + y * ((GrayU8)this.o.template).stride;
                int maskIndex = ((GrayU8)this.o.mask).startIndex + y * ((GrayU8)this.o.mask).stride;
                for (int x = 0; x < ((GrayU8)this.o.template).width; ++x) {
                    double mask = ((GrayU8)this.o.mask).data[maskIndex++] & 0xFF;
                    double error = (double)((((GrayU8)this.o.image).data[imageIndex++] & 0xFF) - (((GrayU8)this.o.template).data[templateIndex++] & 0xFF)) * mask;
                    errorSumSq += error * error;
                }
            }
            return (float)(-(errorSumSq /= this.area) / Math.sqrt((double)this.EPS + this.templateSumSq * imageSumSq));
        }

        @Override
        public void setupTemplate(GrayU8 template, @Nullable GrayU8 mask) {
            this.area = 0.0;
            this.templateSumSq = 0.0;
            for (int y = 0; y < ((GrayU8)this.o.template).height; ++y) {
                int templateIndex = ((GrayU8)this.o.template).startIndex + y * ((GrayU8)this.o.template).stride;
                for (int x = 0; x < ((GrayU8)this.o.template).width; ++x) {
                    double m = mask != null ? (double)mask.unsafe_get(x, y) : 1.0;
                    double v = (double)(((GrayU8)this.o.template).data[templateIndex++] & 0xFF) * m;
                    this.templateSumSq += v * v;
                    this.area += m;
                }
            }
            this.area *= this.area;
            this.templateSumSq /= this.area;
        }
    }

    public static class F32
    extends TemplateSqDiffNormed<GrayF32> {
        float area;
        float templateSumSq;

        @Override
        public float evaluate(int tl_x, int tl_y) {
            float imageSumSq = 0.0f;
            for (int y = 0; y < ((GrayF32)this.o.template).height; ++y) {
                int imageIndex = ((GrayF32)this.o.image).startIndex + (tl_y + y) * ((GrayF32)this.o.image).stride + tl_x;
                for (int x = 0; x < ((GrayF32)this.o.template).width; ++x) {
                    float v = ((GrayF32)this.o.image).data[imageIndex++];
                    imageSumSq += v * v;
                }
            }
            imageSumSq /= this.area;
            float errorSumSq = 0.0f;
            for (int y = 0; y < ((GrayF32)this.o.template).height; ++y) {
                int imageIndex = ((GrayF32)this.o.image).startIndex + (tl_y + y) * ((GrayF32)this.o.image).stride + tl_x;
                int templateIndex = ((GrayF32)this.o.template).startIndex + y * ((GrayF32)this.o.template).stride;
                for (int x = 0; x < ((GrayF32)this.o.template).width; ++x) {
                    float error = ((GrayF32)this.o.image).data[imageIndex++] - ((GrayF32)this.o.template).data[templateIndex++];
                    errorSumSq += error * error;
                }
            }
            return (float)((double)(-(errorSumSq /= this.area)) / Math.sqrt(this.EPS + this.templateSumSq * imageSumSq));
        }

        @Override
        public float evaluateMask(int tl_x, int tl_y) {
            Objects.requireNonNull((GrayF32)this.o.mask);
            float imageSumSq = 0.0f;
            for (int y = 0; y < ((GrayF32)this.o.template).height; ++y) {
                int imageIndex = ((GrayF32)this.o.image).startIndex + (tl_y + y) * ((GrayF32)this.o.image).stride + tl_x;
                int maskIndex = ((GrayF32)this.o.mask).startIndex + y * ((GrayF32)this.o.mask).stride;
                for (int x = 0; x < ((GrayF32)this.o.template).width; ++x) {
                    float v = ((GrayF32)this.o.image).data[imageIndex++] * ((GrayF32)this.o.mask).data[maskIndex++];
                    imageSumSq += v * v;
                }
            }
            imageSumSq /= this.area;
            float errorSumSq = 0.0f;
            for (int y = 0; y < ((GrayF32)this.o.template).height; ++y) {
                int imageIndex = ((GrayF32)this.o.image).startIndex + (tl_y + y) * ((GrayF32)this.o.image).stride + tl_x;
                int templateIndex = ((GrayF32)this.o.template).startIndex + y * ((GrayF32)this.o.template).stride;
                int maskIndex = ((GrayF32)this.o.mask).startIndex + y * ((GrayF32)this.o.mask).stride;
                for (int x = 0; x < ((GrayF32)this.o.template).width; ++x) {
                    float mask = ((GrayF32)this.o.mask).data[maskIndex++];
                    float error = (((GrayF32)this.o.image).data[imageIndex++] - ((GrayF32)this.o.template).data[templateIndex++]) * mask;
                    errorSumSq += error * error;
                }
            }
            return (float)((double)(-(errorSumSq /= this.area)) / Math.sqrt(this.EPS + this.templateSumSq * imageSumSq));
        }

        @Override
        public void setupTemplate(GrayF32 template, @Nullable GrayF32 mask) {
            this.area = 0.0f;
            this.templateSumSq = 0.0f;
            for (int y = 0; y < ((GrayF32)this.o.template).height; ++y) {
                int templateIndex = ((GrayF32)this.o.template).startIndex + y * ((GrayF32)this.o.template).stride;
                for (int x = 0; x < ((GrayF32)this.o.template).width; ++x) {
                    float m = mask != null ? mask.unsafe_get(x, y) : 1.0f;
                    float v = ((GrayF32)this.o.template).data[templateIndex++] * m;
                    this.templateSumSq += v * v;
                    this.area += m;
                }
            }
            this.area *= this.area;
            this.templateSumSq /= this.area;
        }
    }
}

