/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.microqr;

import java.util.ArrayList;
import java.util.List;

public abstract class MicroQrCodeMaskPattern {
    public static final MicroQrCodeMaskPattern M00 = new M00();
    public static final MicroQrCodeMaskPattern M01 = new M01();
    public static final MicroQrCodeMaskPattern M10 = new M10();
    public static final MicroQrCodeMaskPattern M11 = new M11();
    public static final MicroQrCodeMaskPattern NONE = new NONE(0);
    int bits;

    public static List<MicroQrCodeMaskPattern> values() {
        ArrayList<MicroQrCodeMaskPattern> values = new ArrayList<MicroQrCodeMaskPattern>();
        values.add(M00);
        values.add(M01);
        values.add(M10);
        values.add(M11);
        return values;
    }

    protected MicroQrCodeMaskPattern(int bits) {
        this.bits = bits;
    }

    public abstract int apply(int var1, int var2, int var3);

    public static MicroQrCodeMaskPattern lookupMask(int maskPattern) {
        MicroQrCodeMaskPattern microQrCodeMaskPattern;
        switch (maskPattern) {
            case 0: {
                microQrCodeMaskPattern = M00;
                break;
            }
            case 1: {
                microQrCodeMaskPattern = M01;
                break;
            }
            case 2: {
                microQrCodeMaskPattern = M10;
                break;
            }
            case 3: {
                microQrCodeMaskPattern = M11;
                break;
            }
            default: {
                throw new RuntimeException("Unknown mask: " + maskPattern);
            }
        }
        return microQrCodeMaskPattern;
    }

    public static MicroQrCodeMaskPattern lookupMask(String maskPattern) {
        MicroQrCodeMaskPattern microQrCodeMaskPattern;
        switch (maskPattern) {
            case "00": {
                microQrCodeMaskPattern = M00;
                break;
            }
            case "01": {
                microQrCodeMaskPattern = M01;
                break;
            }
            case "10": {
                microQrCodeMaskPattern = M10;
                break;
            }
            case "11": {
                microQrCodeMaskPattern = M11;
                break;
            }
            default: {
                throw new RuntimeException("Unknown mask: " + maskPattern);
            }
        }
        return microQrCodeMaskPattern;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    static class M00
    extends MicroQrCodeMaskPattern {
        public M00() {
            super(0);
        }

        @Override
        public int apply(int row, int col, int bitValue) {
            int mask = row % 2;
            return bitValue ^ ~mask & 1;
        }
    }

    static class M01
    extends MicroQrCodeMaskPattern {
        public M01() {
            super(1);
        }

        @Override
        public int apply(int row, int col, int bitValue) {
            int mask = (row / 2 + col / 3) % 2;
            return bitValue ^ ~mask & 1;
        }
    }

    static class M10
    extends MicroQrCodeMaskPattern {
        public M10() {
            super(2);
        }

        @Override
        public int apply(int row, int col, int bitValue) {
            return bitValue ^ ((row * col % 2 + row * col % 3) % 2 == 0 ? 1 : 0);
        }
    }

    static class M11
    extends MicroQrCodeMaskPattern {
        public M11() {
            super(3);
        }

        @Override
        public int apply(int row, int col, int bitValue) {
            int mask = (row * col % 3 + (row + col) % 2) % 2;
            return bitValue ^ ~mask & 1;
        }
    }

    static class NONE
    extends MicroQrCodeMaskPattern {
        public NONE(int bits) {
            super(bits);
        }

        @Override
        public int apply(int row, int col, int bitValue) {
            return bitValue;
        }
    }
}

