/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.squares;

import boofcv.alg.fiducial.calib.squares.SquareEdge;
import boofcv.alg.fiducial.calib.squares.SquareGrid;
import boofcv.alg.fiducial.calib.squares.SquareNode;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.DogArray;

public class SquareRegularClustersIntoGrids {
    static final int SEARCHED = 1;
    private boolean verbose = false;
    private int minimumElements;
    DogArray<SquareGrid> valid = new DogArray(SquareGrid::new);
    List<SquareNode> nodesLine = new ArrayList<SquareNode>();
    List<SquareNode> column = new ArrayList<SquareNode>();
    List<SquareNode> ordered = new ArrayList<SquareNode>();

    public SquareRegularClustersIntoGrids(int minimumElements) {
        this.minimumElements = minimumElements;
    }

    public void process(List<List<SquareNode>> clusters) {
        this.valid.reset();
        block4: for (int i = 0; i < clusters.size(); ++i) {
            List<SquareNode> graph = clusters.get(i);
            if (graph.size() < this.minimumElements) continue;
            switch (this.checkNumberOfConnections(graph)) {
                case 1: {
                    this.orderIntoLine(graph);
                    continue block4;
                }
                case 2: {
                    this.orderIntoGrid(graph);
                }
            }
        }
    }

    int checkNumberOfConnections(List<SquareNode> graph) {
        int[] histogram = new int[5];
        for (int i = 0; i < graph.size(); ++i) {
            int n = graph.get(i).getNumberOfConnections();
            histogram[n] = histogram[n] + 1;
        }
        if (graph.size() == 1) {
            if (histogram[0] != 1) {
                return 0;
            }
            return 1;
        }
        if (histogram[1] == 2) {
            if (histogram[0] != 0) {
                return 0;
            }
            if (histogram[2] != graph.size() - 2) {
                return 0;
            }
            if (histogram[3] != 0) {
                return 0;
            }
            if (histogram[4] != 0) {
                return 0;
            }
            return 1;
        }
        if (histogram[0] != 0) {
            return 0;
        }
        if (histogram[1] != 0) {
            return 0;
        }
        if (histogram[2] != 4) {
            return 0;
        }
        return 2;
    }

    void orderIntoLine(List<SquareNode> graph) {
        block5: {
            int i;
            for (i = 0; i < graph.size(); ++i) {
                graph.get((int)i).graph = -1;
            }
            this.nodesLine.clear();
            if (graph.size() > 1) {
                for (i = 0; i < graph.size(); ++i) {
                    SquareNode seed = graph.get(i);
                    if (seed.getNumberOfConnections() != 1) continue;
                    seed.graph = 1;
                    this.nodesLine.add(seed);
                    for (int edge = 0; edge < 4; ++edge) {
                        if (seed.edges[edge] == null) continue;
                        Object b = seed.edges[edge].destination(seed);
                        ((SquareNode)b).graph = 1;
                        this.nodesLine.add((SquareNode)b);
                        this.addLineToGrid(seed, (SquareNode)b, this.nodesLine);
                        break block5;
                    }
                }
            } else {
                this.nodesLine.add(graph.get(0));
            }
        }
        SquareGrid grid = (SquareGrid)this.valid.grow();
        grid.nodes.clear();
        grid.nodes.addAll(this.nodesLine);
        grid.columns = this.nodesLine.size();
        grid.rows = 1;
    }

    void orderIntoGrid(List<SquareNode> graph) {
        int i;
        for (i = 0; i < graph.size(); ++i) {
            graph.get((int)i).graph = -1;
        }
        this.column.clear();
        this.ordered.clear();
        for (i = 0; i < graph.size(); ++i) {
            SquareNode seed = graph.get(i);
            if (seed.getNumberOfConnections() != 2) continue;
            seed.graph = 1;
            this.column.add(seed);
            for (int edge = 0; edge < 4; ++edge) {
                if (seed.edges[edge] == null) continue;
                Object b = seed.edges[edge].destination(seed);
                ((SquareNode)b).graph = 1;
                this.column.add((SquareNode)b);
                this.addLineToGrid(seed, (SquareNode)b, this.column);
                break;
            }
            if (!this.addRowsToGrid(this.column, this.ordered)) break;
            return;
        }
        SquareGrid grid = (SquareGrid)this.valid.grow();
        grid.nodes.clear();
        grid.nodes.addAll(this.ordered);
        grid.columns = this.ordered.size() / this.column.size();
        grid.rows = this.column.size();
    }

    boolean addRowsToGrid(List<SquareNode> column, List<SquareNode> ordered) {
        for (int i = 0; i < column.size(); ++i) {
            column.get((int)i).graph = 0;
        }
        int numFirsRow = 0;
        for (int j = 0; j < column.size(); ++j) {
            SquareNode nextRow;
            SquareNode n = column.get(j);
            n.graph = 1;
            ordered.add(n);
            if (j == 0) {
                if (n.getNumberOfConnections() != 2) {
                    if (this.verbose) {
                        System.err.println("Unexpected number of connections. want 2 found " + n.getNumberOfConnections());
                    }
                    return true;
                }
                nextRow = SquareRegularClustersIntoGrids.pickNot(n, column.get(j + 1));
            } else if (j == column.size() - 1) {
                if (n.getNumberOfConnections() != 2) {
                    if (this.verbose) {
                        System.err.println("Unexpected number of connections. want 2 found " + n.getNumberOfConnections());
                    }
                    return true;
                }
                nextRow = SquareRegularClustersIntoGrids.pickNot(n, column.get(j - 1));
            } else {
                if (n.getNumberOfConnections() != 3) {
                    if (this.verbose) {
                        System.err.println("Unexpected number of connections. want 2 found " + n.getNumberOfConnections());
                    }
                    return true;
                }
                nextRow = SquareRegularClustersIntoGrids.pickNot(n, column.get(j - 1), column.get(j + 1));
            }
            nextRow.graph = 1;
            ordered.add(nextRow);
            int numberLine = this.addLineToGrid(n, nextRow, ordered);
            if (j == 0) {
                numFirsRow = numberLine;
                continue;
            }
            if (numberLine == numFirsRow) continue;
            if (this.verbose) {
                System.err.println("Number of elements in rows do not match.");
            }
            return true;
        }
        return false;
    }

    int addLineToGrid(SquareNode a, SquareNode b, List<SquareNode> list) {
        int total = 2;
        while (true) {
            int side;
            boolean matched = false;
            for (side = 0; side < 4; ++side) {
                if (b.edges[side] == null || b.edges[side].destination(b) != a) continue;
                matched = true;
                break;
            }
            if (!matched) {
                throw new RuntimeException("BUG!");
            }
            if (b.edges[side = (side + 2) % 4] == null) break;
            Object c = b.edges[side].destination(b);
            if (((SquareNode)c).graph == 1) break;
            ++total;
            ((SquareNode)c).graph = 1;
            list.add((SquareNode)c);
            a = b;
            b = c;
        }
        return total;
    }

    static SquareNode pickNot(SquareNode target, SquareNode child) {
        for (int i = 0; i < 4; ++i) {
            Object c;
            SquareEdge e = target.edges[i];
            if (e == null || (c = e.destination(target)) == child) continue;
            return c;
        }
        throw new RuntimeException("There was no odd one out some how");
    }

    static SquareNode pickNot(SquareNode target, SquareNode child0, SquareNode child1) {
        for (int i = 0; i < 4; ++i) {
            Object c;
            SquareEdge e = target.edges[i];
            if (e == null || (c = e.destination(target)) == child0 || c == child1) continue;
            return c;
        }
        throw new RuntimeException("There was no odd one out some how");
    }

    public List<SquareGrid> getGrids() {
        return this.valid.toList();
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

