/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib;

import boofcv.abst.fiducial.calib.CalibrationPatterns;
import boofcv.abst.fiducial.calib.ConfigECoCheckMarkers;
import boofcv.abst.fiducial.calib.ConfigGridDimen;
import boofcv.factory.fiducial.ConfigHammingChessboard;
import boofcv.factory.fiducial.ConfigHammingGrid;
import boofcv.struct.Configuration;
import org.jetbrains.annotations.Nullable;

public class ConfigCalibrationTarget
implements Configuration {
    @Nullable
    public CalibrationPatterns type = CalibrationPatterns.CHESSBOARD;
    public ConfigECoCheckMarkers ecocheck = new ConfigECoCheckMarkers();
    public ConfigHammingChessboard hammingChess = new ConfigHammingChessboard();
    public ConfigHammingGrid hammingGrid = new ConfigHammingGrid();
    public ConfigGridDimen grid = new ConfigGridDimen();

    public Configuration getActiveDescription() {
        Object object;
        if (this.type == null) {
            return this.grid;
        }
        switch (this.type) {
            case ECOCHECK: {
                object = this.ecocheck;
                break;
            }
            case HAMMING_CHESSBOARD: {
                object = this.hammingChess;
                break;
            }
            case HAMMING_GRID: {
                object = this.hammingGrid;
                break;
            }
            default: {
                object = this.grid;
            }
        }
        return object;
    }

    public void checkValidity() {
        this.getActiveDescription().checkValidity();
    }

    public ConfigCalibrationTarget setTo(ConfigCalibrationTarget src) {
        this.type = src.type;
        this.ecocheck.setTo(src.ecocheck);
        this.hammingChess.setTo(src.hammingChess);
        this.hammingGrid.setTo(src.hammingGrid);
        this.grid.setTo(src.grid);
        return this;
    }

    public String toString() {
        String text = "ConfigCalibrationTarget{type=" + this.type + " grid=" + this.grid.toString();
        if (this.type != null) {
            switch (this.type) {
                case ECOCHECK: {
                    text = text + " ecocheck=" + this.ecocheck.toString();
                    break;
                }
                case HAMMING_CHESSBOARD: {
                    text = text + "hamming=" + this.hammingChess.toString();
                    break;
                }
                case HAMMING_GRID: {
                    text = text + "hamming=" + this.hammingGrid.toString();
                    break;
                }
            }
        }
        return text + "}";
    }
}

