/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.fiducial;

import boofcv.factory.fiducial.ConfigHammingMarker;
import boofcv.factory.fiducial.HammingDictionary;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.Configuration;

public class ConfigHammingGrid
implements Configuration {
    public int numRows = -1;
    public int numCols = -1;
    public double squareSize = 1.0;
    public double spaceToSquare = 0.4;
    public int markerOffset = 0;
    public ConfigHammingMarker markers;

    public ConfigHammingGrid(ConfigHammingMarker dictionary) {
        this.markers = dictionary;
    }

    public ConfigHammingGrid() {
        this.markers = ConfigHammingMarker.loadDictionary(HammingDictionary.ARUCO_MIP_25h7);
    }

    public void checkValidity() {
        BoofMiscOps.checkTrue((this.numRows > 0 ? 1 : 0) != 0);
        BoofMiscOps.checkTrue((this.numCols > 0 ? 1 : 0) != 0);
        BoofMiscOps.checkTrue((this.spaceToSquare > 0.0 ? 1 : 0) != 0);
        BoofMiscOps.checkTrue((this.markerOffset > 0 ? 1 : 0) != 0);
        this.markers.checkValidity();
    }

    public ConfigHammingGrid setTo(ConfigHammingGrid src) {
        this.numRows = src.numRows;
        this.numCols = src.numCols;
        this.squareSize = src.squareSize;
        this.spaceToSquare = src.spaceToSquare;
        this.markerOffset = src.markerOffset;
        this.markers.setTo(src.markers);
        return this;
    }

    public double getMarkerWidth() {
        return (double)(this.numCols - 1) * (1.0 + this.spaceToSquare) * this.squareSize + this.squareSize;
    }

    public double getMarkerHeight() {
        return (double)(this.numRows - 1) * (1.0 + this.spaceToSquare) * this.squareSize + this.squareSize;
    }

    public static ConfigHammingGrid create(HammingDictionary dictionary, int rows, int cols, double squareSize, double spaceToSquare) {
        ConfigHammingMarker configDictionary = ConfigHammingMarker.loadDictionary(dictionary);
        ConfigHammingGrid config = new ConfigHammingGrid(configDictionary);
        config.numRows = rows;
        config.numCols = cols;
        config.squareSize = squareSize;
        config.spaceToSquare = spaceToSquare;
        return config;
    }
}

