/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.fiducial;

import boofcv.abst.shapes.polyline.ConfigPolylineSplitMerge;
import boofcv.factory.filter.binary.ConfigThreshold;
import boofcv.factory.filter.binary.ThresholdType;
import boofcv.factory.shape.ConfigPolygonDetector;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.ConfigLength;
import boofcv.struct.Configuration;
import java.util.Objects;

public class ConfigFiducialHammingDetector
implements Configuration {
    public double minimumBlackBorderFraction = 0.65;
    public double ambiguousPenaltyFrac = 0.5;
    public ConfigPolygonDetector squareDetector = new ConfigPolygonDetector();
    public ConfigThreshold configThreshold = ConfigThreshold.local((ThresholdType)ThresholdType.LOCAL_MEAN, (int)21);

    public ConfigFiducialHammingDetector() {
        ((ConfigPolylineSplitMerge)this.squareDetector.detector.contourToPoly).cornerScorePenalty = 0.2;
        ((ConfigPolylineSplitMerge)this.squareDetector.detector.contourToPoly).thresholdSideSplitScore = 0.0;
        this.squareDetector.detector.minimumContour = ConfigLength.fixed((double)20.0);
        Objects.requireNonNull(this.squareDetector.refineGray).cornerOffset = 0.0;
    }

    public ConfigFiducialHammingDetector setTo(ConfigFiducialHammingDetector src) {
        this.minimumBlackBorderFraction = src.minimumBlackBorderFraction;
        this.ambiguousPenaltyFrac = src.ambiguousPenaltyFrac;
        this.squareDetector.setTo(src.squareDetector);
        this.configThreshold.setTo(src.configThreshold);
        return this;
    }

    public void checkValidity() {
        BoofMiscOps.checkTrue((this.minimumBlackBorderFraction >= 0.0 ? 1 : 0) != 0);
        BoofMiscOps.checkTrue((this.ambiguousPenaltyFrac >= 0.0 ? 1 : 0) != 0);
        this.squareDetector.checkValidity();
        this.configThreshold.checkValidity();
    }

    public double getAmbiguousPenaltyFrac() {
        return this.ambiguousPenaltyFrac;
    }

    public void setAmbiguousPenaltyFrac(double ambiguousPenaltyFrac) {
        this.ambiguousPenaltyFrac = ambiguousPenaltyFrac;
    }
}

