/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.meanshift;

import boofcv.alg.tracker.meanshift.LocalWeightedHistogramRotRect;
import boofcv.struct.RectangleRotate_F32;
import boofcv.struct.image.ImageBase;
import georegression.struct.point.Point2D_F32;
import java.util.List;

public class TrackerMeanShiftComaniciu2003<T extends ImageBase<T>> {
    private final LocalWeightedHistogramRotRect<T> calcHistogram;
    protected float[] keyHistogram;
    protected float[] weightHistogram;
    protected float scaleChange;
    private final RectangleRotate_F32 region = new RectangleRotate_F32();
    private final int maxIterations;
    private final float minimumChange;
    private final RectangleRotate_F32 region0 = new RectangleRotate_F32();
    private final RectangleRotate_F32 region1 = new RectangleRotate_F32();
    private final RectangleRotate_F32 region2 = new RectangleRotate_F32();
    private float[] histogram0;
    private float[] histogram1;
    private float[] histogram2;
    private final float gamma;
    private final boolean updateHistogram;
    private final boolean constantScale;
    private final float minimumSizeRatio;
    private float minimumWidth;

    public TrackerMeanShiftComaniciu2003(boolean updateHistogram, int maxIterations, float minimumChange, float gamma, float minimumSizeRatio, float scaleChange, LocalWeightedHistogramRotRect<T> calcHistogram) {
        if (scaleChange < 0.0f || scaleChange > 1.0f) {
            throw new IllegalArgumentException("Scale change must be >= 0 and <= 1");
        }
        this.updateHistogram = updateHistogram;
        this.maxIterations = maxIterations;
        this.minimumChange = minimumChange;
        this.gamma = gamma;
        this.scaleChange = scaleChange;
        this.constantScale = scaleChange == 0.0f;
        this.minimumSizeRatio = minimumSizeRatio;
        this.calcHistogram = calcHistogram;
        this.keyHistogram = new float[calcHistogram.getHistogram().length];
        this.weightHistogram = new float[this.keyHistogram.length];
        if (updateHistogram) {
            this.histogram0 = new float[calcHistogram.getHistogram().length];
            this.histogram1 = new float[calcHistogram.getHistogram().length];
            this.histogram2 = new float[calcHistogram.getHistogram().length];
        }
    }

    public void initialize(T image, RectangleRotate_F32 initial) {
        this.region.set(initial);
        this.calcHistogram.computeHistogram(image, initial);
        System.arraycopy(this.calcHistogram.getHistogram(), 0, this.keyHistogram, 0, this.keyHistogram.length);
        this.minimumWidth = initial.width * this.minimumSizeRatio;
    }

    public void setTrackLocation(RectangleRotate_F32 location) {
        this.region.set(location);
        this.minimumWidth = location.width * this.minimumSizeRatio;
    }

    public void track(T image) {
        float[] selectedHist;
        RectangleRotate_F32 selected;
        this.region0.set(this.region);
        this.region1.set(this.region);
        this.region2.set(this.region);
        this.region0.width *= 1.0f - this.scaleChange;
        this.region0.height *= 1.0f - this.scaleChange;
        this.region2.width *= 1.0f + this.scaleChange;
        this.region2.height *= 1.0f + this.scaleChange;
        double distance0 = 1.0;
        double distance2 = 1.0;
        if (!this.constantScale) {
            if (this.region0.width >= this.minimumWidth) {
                this.updateLocation(image, this.region0);
                distance0 = this.distanceHistogram(this.keyHistogram, this.calcHistogram.getHistogram());
                if (this.updateHistogram) {
                    System.arraycopy(this.calcHistogram.getHistogram(), 0, this.histogram0, 0, this.histogram0.length);
                }
            }
            this.updateLocation(image, this.region2);
            distance2 = this.distanceHistogram(this.keyHistogram, this.calcHistogram.getHistogram());
            if (this.updateHistogram) {
                System.arraycopy(this.calcHistogram.getHistogram(), 0, this.histogram2, 0, this.histogram2.length);
            }
        }
        this.updateLocation(image, this.region1);
        double distance1 = !this.constantScale ? this.distanceHistogram(this.keyHistogram, this.calcHistogram.getHistogram()) : 0.0;
        if (this.updateHistogram) {
            System.arraycopy(this.calcHistogram.getHistogram(), 0, this.histogram1, 0, this.histogram1.length);
        }
        switch (this.selectBest(distance0, distance1, distance2)) {
            case 0: {
                selected = this.region0;
                selectedHist = this.histogram0;
                break;
            }
            case 1: {
                selected = this.region1;
                selectedHist = this.histogram1;
                break;
            }
            case 2: {
                selected = this.region2;
                selectedHist = this.histogram2;
                break;
            }
            default: {
                throw new RuntimeException("Bug in selectBest");
            }
        }
        float w = selected.width * (1.0f - this.gamma) + this.gamma * this.region.width;
        float h = selected.height * (1.0f - this.gamma) + this.gamma * this.region.height;
        this.region.set(selected);
        this.region.width = w;
        this.region.height = h;
        if (this.updateHistogram) {
            System.arraycopy(selectedHist, 0, this.keyHistogram, 0, this.keyHistogram.length);
        }
    }

    private int selectBest(double a, double b, double c) {
        if (a < b) {
            if (a < c) {
                return 0;
            }
            return 2;
        }
        if (b <= c) {
            return 1;
        }
        return 2;
    }

    protected void updateLocation(T image, RectangleRotate_F32 region) {
        double bestHistScore = Double.MAX_VALUE;
        float bestX = -1.0f;
        float bestY = -1.0f;
        for (int i = 0; i < this.maxIterations; ++i) {
            this.calcHistogram.computeHistogram(image, region);
            float[] histogram = this.calcHistogram.getHistogram();
            this.updateWeights(histogram);
            double histScore = this.distanceHistogram(this.keyHistogram, histogram);
            if (histScore < bestHistScore) {
                bestHistScore = histScore;
                bestX = region.cx;
                bestY = region.cy;
            }
            List<Point2D_F32> samples = this.calcHistogram.getSamplePts();
            int[] sampleHistIndex = this.calcHistogram.getSampleHistIndex();
            float meanX = 0.0f;
            float meanY = 0.0f;
            float totalWeight = 0.0f;
            for (int j = 0; j < samples.size(); ++j) {
                Point2D_F32 samplePt = samples.get(j);
                int histIndex = sampleHistIndex[j];
                if (histIndex < 0) continue;
                float w = this.weightHistogram[histIndex];
                meanX += w * samplePt.x;
                meanY += w * samplePt.y;
                totalWeight += w;
            }
            this.calcHistogram.squareToImageSample(meanX /= totalWeight, meanY /= totalWeight, region);
            meanX = this.calcHistogram.imageX;
            meanY = this.calcHistogram.imageY;
            boolean done = Math.abs(meanX - region.cx) <= this.minimumChange && Math.abs(meanY - region.cy) <= this.minimumChange;
            region.cx = meanX;
            region.cy = meanY;
            if (done) break;
        }
        region.cx = bestX;
        region.cy = bestY;
    }

    private void updateWeights(float[] histogram) {
        for (int j = 0; j < this.weightHistogram.length; ++j) {
            float h = histogram[j];
            if (h == 0.0f) continue;
            this.weightHistogram[j] = (float)Math.sqrt(this.keyHistogram[j] / h);
        }
    }

    protected double distanceHistogram(float[] histogramA, float[] histogramB) {
        double sumP = 0.0;
        for (int i = 0; i < histogramA.length; ++i) {
            float q = histogramA[i];
            float p = histogramB[i];
            sumP += (double)Math.abs(q - p);
        }
        return sumP;
    }

    public RectangleRotate_F32 getRegion() {
        return this.region;
    }
}

