/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

import boofcv.alg.fiducial.qrcode.GaliosFieldOps;
import boofcv.alg.fiducial.qrcode.GaliosFieldTableOps_U16;
import java.util.Arrays;
import org.ddogleg.struct.DogArray_I16;
import org.ddogleg.struct.DogArray_I32;

public class ReedSolomonCodes_U16 {
    GaliosFieldTableOps_U16 math;
    DogArray_I16 generator = new DogArray_I16();
    DogArray_I16 tmp0 = new DogArray_I16();
    DogArray_I16 tmp1 = new DogArray_I16();
    DogArray_I32 errorLocations = new DogArray_I32();
    DogArray_I16 errorLocatorPoly = new DogArray_I16();
    DogArray_I16 syndromes = new DogArray_I16();
    DogArray_I16 err_eval = new DogArray_I16();
    DogArray_I16 errorX = new DogArray_I16();
    DogArray_I16 err_loc_prime_tmp = new DogArray_I16();
    int generatorBase;

    public ReedSolomonCodes_U16(int numBits, int primitive, int generatorBase) {
        if (generatorBase < 0 || generatorBase > 1) {
            throw new IllegalArgumentException("generatorBase must be 0 or 1");
        }
        this.math = new GaliosFieldTableOps_U16(numBits, primitive);
        this.generatorBase = generatorBase;
    }

    public void computeECC(DogArray_I16 input, DogArray_I16 output) {
        int N = this.generator.size - 1;
        input.extend(input.size + N);
        Arrays.fill(input.data, input.size - N, input.size, (short)0);
        this.math.polyDivide(input, this.generator, this.tmp0, output);
        input.size -= N;
    }

    public boolean correct(DogArray_I16 input, DogArray_I16 ecc) {
        this.computeSyndromes(input, ecc, this.syndromes);
        this.findErrorLocatorPolynomialBM(this.syndromes, this.errorLocatorPoly);
        if (!this.findErrorLocations_BruteForce(this.errorLocatorPoly, input.size + ecc.size, this.errorLocations)) {
            return false;
        }
        this.correctErrors(input, input.size + ecc.size, this.syndromes, this.errorLocatorPoly, this.errorLocations);
        return true;
    }

    void computeSyndromes(DogArray_I16 input, DogArray_I16 ecc, DogArray_I16 syndromes) {
        syndromes.resize(this.syndromeLength());
        for (int i = 0; i < syndromes.size; ++i) {
            int val = this.generatorPower(i);
            int eval = this.math.polyEval(input, val);
            syndromes.data[i] = (short)this.math.polyEvalContinue(eval, ecc, val);
        }
    }

    void findErrorLocatorPolynomialBM(DogArray_I16 syndromes, DogArray_I16 errorLocator) {
        DogArray_I16 C = errorLocator;
        DogArray_I16 B = this.err_eval;
        this.initToOne(C, syndromes.size + 1);
        this.initToOne(B, syndromes.size + 1);
        DogArray_I16 tmp = this.errorX;
        tmp.resize(syndromes.size);
        int b = 1;
        for (int n = 0; n < syndromes.size; ++n) {
            int delta = syndromes.data[n] & 0xFFFF;
            for (int j = 1; j < C.size; ++j) {
                delta ^= this.math.multiply(C.data[C.size - j - 1] & 0xFFFF, syndromes.data[n - j] & 0xFFFF);
            }
            B.data[B.size++] = 0;
            if (delta == 0) continue;
            int scale = this.math.multiply(delta, this.math.inverse(b));
            this.math.polyAddScaleB(C, B, scale, tmp);
            if (B.size > C.size) {
                B.setTo(C);
                b = delta;
            }
            C.setTo(tmp);
        }
        this.removeLeadingZeros(C);
    }

    private void removeLeadingZeros(DogArray_I16 poly) {
        int count;
        for (count = 0; count < poly.size && poly.data[count] == 0; ++count) {
        }
        for (int i = count; i < poly.size; ++i) {
            poly.data[i - count] = poly.data[i];
        }
        poly.size -= count;
    }

    void findErrorLocatorPolynomial(int messageLength, DogArray_I32 errorLocations, DogArray_I16 errorLocator) {
        this.tmp1.resize(2);
        this.tmp1.data[1] = 1;
        errorLocator.resize(1);
        errorLocator.data[0] = 1;
        for (int i = 0; i < errorLocations.size; ++i) {
            int where = messageLength - errorLocations.get(i) - 1;
            this.tmp1.data[0] = (short)this.math.power(2, where);
            this.tmp0.setTo(errorLocator);
            this.math.polyMult(this.tmp0, this.tmp1, errorLocator);
        }
    }

    public boolean findErrorLocations_BruteForce(DogArray_I16 errorLocator, int messageLength, DogArray_I32 locations) {
        locations.resize(0);
        for (int i = 0; i < messageLength; ++i) {
            if (this.math.polyEval_S(errorLocator, this.math.power(2, i)) != 0) continue;
            locations.add(messageLength - i - 1);
        }
        return locations.size == errorLocator.size - 1;
    }

    void correctErrors(DogArray_I16 message, int length_msg_ecc, DogArray_I16 syndromes, DogArray_I16 errorLocator, DogArray_I32 errorLocations) {
        int i;
        this.findErrorEvaluator(syndromes, errorLocator, this.err_eval);
        this.errorX.reset().resize(errorLocations.size, (short)0);
        for (i = 0; i < errorLocations.size; ++i) {
            int coef_pos = length_msg_ecc - errorLocations.data[i] - 1;
            this.errorX.data[i] = (short)this.math.power(2, coef_pos);
        }
        this.err_loc_prime_tmp.resize(this.errorX.size);
        for (i = 0; i < this.errorX.size; ++i) {
            int loc;
            int Xi = this.errorX.data[i] & 0xFFFF;
            int Xi_inv = this.math.inverse(Xi);
            this.err_loc_prime_tmp.size = 0;
            for (int j = 0; j < this.errorX.size; ++j) {
                if (i == j) continue;
                this.err_loc_prime_tmp.data[this.err_loc_prime_tmp.size++] = (short)GaliosFieldOps.subtract(1, this.math.multiply(Xi_inv, this.errorX.data[j] & 0xFFFF));
            }
            int err_loc_prime = 1;
            for (int j = 0; j < this.err_loc_prime_tmp.size; ++j) {
                err_loc_prime = this.math.multiply(err_loc_prime, this.err_loc_prime_tmp.data[j] & 0xFFFF);
            }
            int y = this.math.polyEval_S(this.err_eval, Xi_inv);
            y = this.math.multiply(this.math.power(Xi, 1), y);
            int magnitude = this.math.divide(y, err_loc_prime);
            if (this.generatorBase != 0) {
                magnitude = this.math.multiply(magnitude, Xi_inv);
            }
            if ((loc = errorLocations.get(i)) >= message.size) continue;
            message.data[loc] = (short)(message.data[loc] & 0xFFFF ^ magnitude);
        }
    }

    void findErrorEvaluator(DogArray_I16 syndromes, DogArray_I16 errorLocator, DogArray_I16 evaluator) {
        int i;
        this.math.polyMult_flipA(syndromes, errorLocator, evaluator);
        int N = errorLocator.size - 1;
        int offset = evaluator.size - N;
        for (i = 0; i < N; ++i) {
            evaluator.data[i] = evaluator.data[i + offset];
        }
        evaluator.data[N] = 0;
        evaluator.size = errorLocator.size;
        for (i = 0; i < evaluator.size / 2; ++i) {
            int j = evaluator.size - i - 1;
            short tmp = evaluator.data[i];
            evaluator.data[i] = evaluator.data[j];
            evaluator.data[j] = tmp;
        }
    }

    public void generator(int degree) {
        this.initToOne(this.generator, degree + 1);
        this.tmp1.resize(2);
        this.tmp1.data[0] = 1;
        for (int i = 0; i < degree; ++i) {
            this.tmp1.data[1] = (short)this.generatorPower(i);
            this.math.polyMult(this.generator, this.tmp1, this.tmp0);
            this.generator.setTo(this.tmp0);
        }
    }

    void initToOne(DogArray_I16 poly, int length) {
        poly.reset();
        poly.reserve(length);
        poly.size = 1;
        poly.data[0] = 1;
    }

    int generatorPower(int level) {
        return this.math.power(2, level + this.generatorBase);
    }

    private int syndromeLength() {
        return this.generator.size - 1;
    }

    public int getTotalErrors() {
        return this.errorLocations.size;
    }

    public int getGeneratorBase() {
        return this.generatorBase;
    }
}

