/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

import java.util.ArrayList;
import java.util.List;

public abstract class QrCodeMaskPattern {
    public static final QrCodeMaskPattern M000 = new M000();
    public static final QrCodeMaskPattern M001 = new M001();
    public static final QrCodeMaskPattern M010 = new M010();
    public static final QrCodeMaskPattern M011 = new M011();
    public static final QrCodeMaskPattern M100 = new M100();
    public static final QrCodeMaskPattern M101 = new M101();
    public static final QrCodeMaskPattern M110 = new M110();
    public static final QrCodeMaskPattern M111 = new M111();
    int bits;

    public static List<QrCodeMaskPattern> values() {
        ArrayList<QrCodeMaskPattern> values = new ArrayList<QrCodeMaskPattern>();
        values.add(M001);
        values.add(M010);
        values.add(M011);
        values.add(M100);
        values.add(M101);
        values.add(M110);
        values.add(M111);
        return values;
    }

    protected QrCodeMaskPattern(int bits) {
        this.bits = bits;
    }

    public abstract int apply(int var1, int var2, int var3);

    public static QrCodeMaskPattern lookupMask(int maskPattern) {
        QrCodeMaskPattern qrCodeMaskPattern;
        switch (maskPattern) {
            case 0: {
                qrCodeMaskPattern = M000;
                break;
            }
            case 1: {
                qrCodeMaskPattern = M001;
                break;
            }
            case 2: {
                qrCodeMaskPattern = M010;
                break;
            }
            case 3: {
                qrCodeMaskPattern = M011;
                break;
            }
            case 4: {
                qrCodeMaskPattern = M100;
                break;
            }
            case 5: {
                qrCodeMaskPattern = M101;
                break;
            }
            case 6: {
                qrCodeMaskPattern = M110;
                break;
            }
            case 7: {
                qrCodeMaskPattern = M111;
                break;
            }
            default: {
                throw new RuntimeException("Unknown mask: " + maskPattern);
            }
        }
        return qrCodeMaskPattern;
    }

    public static QrCodeMaskPattern lookupMask(String maskPattern) {
        QrCodeMaskPattern qrCodeMaskPattern;
        switch (maskPattern) {
            case "000": {
                qrCodeMaskPattern = M000;
                break;
            }
            case "001": {
                qrCodeMaskPattern = M001;
                break;
            }
            case "010": {
                qrCodeMaskPattern = M010;
                break;
            }
            case "011": {
                qrCodeMaskPattern = M011;
                break;
            }
            case "100": {
                qrCodeMaskPattern = M100;
                break;
            }
            case "101": {
                qrCodeMaskPattern = M101;
                break;
            }
            case "110": {
                qrCodeMaskPattern = M110;
                break;
            }
            case "111": {
                qrCodeMaskPattern = M111;
                break;
            }
            default: {
                throw new RuntimeException("Unknown mask: " + maskPattern);
            }
        }
        return qrCodeMaskPattern;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    static class M000
    extends QrCodeMaskPattern {
        public M000() {
            super(0);
        }

        @Override
        public int apply(int row, int col, int bitValue) {
            int mask = (row + col) % 2;
            return bitValue ^ ~mask & 1;
        }
    }

    static class M001
    extends QrCodeMaskPattern {
        public M001() {
            super(1);
        }

        @Override
        public int apply(int row, int col, int bitValue) {
            int mask = row % 2;
            return bitValue ^ ~mask & 1;
        }
    }

    static class M010
    extends QrCodeMaskPattern {
        public M010() {
            super(2);
        }

        @Override
        public int apply(int row, int col, int bitValue) {
            return bitValue ^ (col % 3 == 0 ? 1 : 0);
        }
    }

    static class M011
    extends QrCodeMaskPattern {
        public M011() {
            super(3);
        }

        @Override
        public int apply(int row, int col, int bitValue) {
            return bitValue ^ ((row + col) % 3 == 0 ? 1 : 0);
        }
    }

    static class M100
    extends QrCodeMaskPattern {
        public M100() {
            super(4);
        }

        @Override
        public int apply(int row, int col, int bitValue) {
            int mask = (row / 2 + col / 3) % 2;
            return bitValue ^ ~mask & 1;
        }
    }

    static class M101
    extends QrCodeMaskPattern {
        public M101() {
            super(5);
        }

        @Override
        public int apply(int row, int col, int bitValue) {
            return bitValue ^ (row * col % 2 + row * col % 3 == 0 ? 1 : 0);
        }
    }

    static class M110
    extends QrCodeMaskPattern {
        public M110() {
            super(6);
        }

        @Override
        public int apply(int row, int col, int bitValue) {
            return bitValue ^ ((row * col % 2 + row * col % 3) % 2 == 0 ? 1 : 0);
        }
    }

    static class M111
    extends QrCodeMaskPattern {
        public M111() {
            super(7);
        }

        @Override
        public int apply(int row, int col, int bitValue) {
            int mask = (row * col % 3 + (row + col) % 2) % 2;
            return bitValue ^ ~mask & 1;
        }
    }

    static class NONE
    extends QrCodeMaskPattern {
        public NONE(int bits) {
            super(bits);
        }

        @Override
        public int apply(int row, int col, int bitValue) {
            return bitValue;
        }
    }
}

