/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

import boofcv.alg.fiducial.qrcode.GaliosFieldOps;

public class GaliosFieldTableOps {
    protected int max_value;
    protected int num_values;
    protected int numBits;
    protected int primitive;
    protected int[] exp;
    protected int[] log;

    public GaliosFieldTableOps(int numBits, int primitive) {
        if (numBits < 1 || numBits > 16) {
            throw new IllegalArgumentException("Degree must be more than 1 and less than or equal to 16");
        }
        this.numBits = numBits;
        this.primitive = primitive;
        this.max_value = 0;
        for (int i = 0; i < numBits; ++i) {
            this.max_value |= 1 << i;
        }
        this.num_values = this.max_value + 1;
        this.log = new int[this.num_values];
        this.exp = new int[this.num_values * 2];
        int x = 1;
        int i = 0;
        while (i < this.max_value) {
            this.exp[i] = x;
            this.log[x] = i++;
            x = GaliosFieldOps.multiply(x, 2, primitive, this.num_values);
        }
        for (i = 0; i < this.num_values; ++i) {
            this.exp[i + this.max_value] = this.exp[i];
        }
    }

    public int multiply(int x, int y) {
        if (x == 0 || y == 0) {
            return 0;
        }
        return this.exp[this.log[x] + this.log[y]];
    }

    public int divide(int x, int y) {
        if (y == 0) {
            throw new ArithmeticException("Divide by zero");
        }
        if (x == 0) {
            return 0;
        }
        return this.exp[this.log[x] + this.max_value - this.log[y]];
    }

    public int power(int x, int power) {
        return this.exp[this.log[x] * power % this.max_value];
    }

    public int power_n(int x, int power) {
        int a = this.log[x] * power % this.max_value;
        if (a < 0) {
            a = this.max_value * 2 + a;
        }
        return this.exp[a];
    }

    public int inverse(int x) {
        return this.exp[this.max_value - this.log[x]];
    }
}

