/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.hammingchess;

import boofcv.alg.drawing.FiducialRenderEngine;
import boofcv.alg.fiducial.square.FiducialSquareHammingGenerator;
import boofcv.factory.fiducial.ConfigHammingChessboard;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;

public class HammingChessboardGenerator {
    public double squareWidth = 1.0;
    protected FiducialRenderEngine render;
    final ConfigHammingChessboard config;
    private final FiducialSquareHammingGenerator squareGenerator;
    public final List<Point2D_F64> corners = new ArrayList<Point2D_F64>();

    public HammingChessboardGenerator(ConfigHammingChessboard config) {
        this.config = config;
        this.squareGenerator = new FiducialSquareHammingGenerator(config.markers);
    }

    public void render() {
        this.render.init();
        this.render.setGray(0.0);
        this.squareGenerator.setRenderer(this.render);
        double w = this.squareWidth * this.config.squareSize;
        double markerOffset = w * (1.0 - this.config.markerScale) / 2.0;
        this.squareGenerator.setMarkerWidth(w * this.config.markerScale);
        int markerIndex = this.config.markerOffset;
        for (int row = 0; row < this.config.numRows; ++row) {
            double y = (double)row * w;
            for (int col = 0; col < this.config.numCols; ++col) {
                boolean drawSquare;
                double x = (double)col * w;
                if (this.config.chessboardEven) {
                    drawSquare = col % 2 == row % 2;
                } else {
                    boolean bl = drawSquare = col % 2 != row % 2;
                }
                if (drawSquare) {
                    this.render.square(x, y, w);
                    continue;
                }
                this.squareGenerator.offsetX = x + markerOffset;
                this.squareGenerator.offsetY = y + markerOffset;
                this.squareGenerator.generateNoInit(markerIndex++);
            }
        }
        this.saveCornerLocations();
    }

    public void saveCornerLocations() {
        this.corners.clear();
        int rows = this.config.numRows - 1;
        int cols = this.config.numCols - 1;
        double w = this.squareWidth * this.config.squareSize;
        for (int row = 0; row < rows; ++row) {
            double y = w * (double)(rows - row);
            for (int col = 0; col < cols; ++col) {
                double x = w * (double)(col + 1);
                this.corners.add(new Point2D_F64(x, y));
            }
        }
    }

    public void setSquareWidth(double squareWidth) {
        this.squareWidth = squareWidth;
    }

    public double getSquareWidth() {
        return this.squareWidth;
    }

    public void setRender(FiducialRenderEngine render) {
        this.render = render;
    }
}

