/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.aztec;

import georegression.geometry.UtilPolygons2D_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import org.ddogleg.struct.DogArray;

public class AztecPyramid {
    public final DogArray<Layer> layers = new DogArray(Layer::new, Layer::reset);

    public void resize(int numLayers) {
        this.layers.reset().resize(numLayers);
    }

    public Layer get(int index) {
        return (Layer)this.layers.get(index);
    }

    public void alignCorners() {
        if (this.layers.size <= 1) {
            return;
        }
        double bestError = Double.MAX_VALUE;
        int best = -1;
        Polygon2D_F64 a = ((Layer)this.layers.get((int)0)).square;
        Polygon2D_F64 b = ((Layer)this.layers.get((int)1)).square;
        for (int i = 0; i < 4; ++i) {
            double distance = a.get(0).distance2((GeoTuple2D_F64)b.get(i));
            if (!(distance < bestError)) continue;
            bestError = distance;
            best = i;
        }
        for (int rotateIdx = 0; rotateIdx < best; ++rotateIdx) {
            UtilPolygons2D_F64.shiftUp((Polygon2D_F64)b);
        }
    }

    public int getGridWidth() {
        return this.layers.size == 1 ? 11 : 15;
    }

    public void setTo(AztecPyramid src) {
        this.layers.reset().resize(src.layers.size);
        for (int i = 0; i < src.layers.size; ++i) {
            ((Layer)this.layers.get(i)).setTo((Layer)src.layers.get(i));
        }
    }

    public void reset() {
        this.layers.reset();
    }

    public boolean isIdentical(AztecPyramid b) {
        if (this.layers.size != b.layers.size) {
            return false;
        }
        for (int i = 0; i < this.layers.size; ++i) {
            if (((Layer)this.layers.get(i)).isIdentical((Layer)b.layers.get(i))) continue;
            return false;
        }
        return true;
    }

    public static class Layer {
        public final Polygon2D_F64 square = new Polygon2D_F64(4);
        public final Point2D_F64 center = new Point2D_F64();
        public double threshold;

        public void setTo(Layer src) {
            this.square.setTo(src.square);
            this.center.setTo(src.center);
            this.threshold = src.threshold;
        }

        public void reset() {
            this.square.zero();
            this.threshold = -1.0;
        }

        public boolean isIdentical(Layer a) {
            if (!this.square.isIdentical(a.square, 0.0)) {
                return false;
            }
            if (!this.center.isIdentical((GeoTuple2D_F64)a.center, 0.0)) {
                return false;
            }
            return this.threshold == a.threshold;
        }
    }
}

