/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

public class GaliosFieldOps {
    public static int add(int a, int b) {
        return a ^ b;
    }

    public static int subtract(int a, int b) {
        return a ^ b;
    }

    public static int multiply(int a, int b) {
        int z = 0;
        int i = 0;
        while (b >> i > 0) {
            if ((b & 1 << i) != 0) {
                z ^= a << i;
            }
            ++i;
        }
        return z;
    }

    public static int multiply(int x, int y, int primitive, int domain) {
        int r = 0;
        while (y > 0) {
            if ((y & 1) != 0) {
                r ^= x;
            }
            y >>= 1;
            if ((x <<= 1) < domain) continue;
            x ^= primitive;
        }
        return r;
    }

    public static int modulus(int dividend, int divisor) {
        int length_sor;
        int length_end = GaliosFieldOps.length(dividend);
        if (length_end < (length_sor = GaliosFieldOps.length(divisor))) {
            return dividend;
        }
        for (int i = length_end - length_sor; i >= 0; --i) {
            if ((dividend & 1 << i + length_sor - 1) == 0) continue;
            dividend ^= divisor << i;
        }
        return dividend;
    }

    public static int divide(int dividend, int divisor) {
        int length_sor;
        int length_end = GaliosFieldOps.length(dividend);
        if (length_end < (length_sor = GaliosFieldOps.length(divisor))) {
            return 0;
        }
        int result = 0;
        for (int i = length_end - length_sor; i >= 0; --i) {
            if ((dividend & 1 << i + length_sor - 1) == 0) continue;
            dividend ^= divisor << i;
            result |= 1 << i;
        }
        return result;
    }

    public static int length(int value) {
        int length = 0;
        while (value >> length != 0) {
            ++length;
        }
        return length;
    }
}

