/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial.calib;

import boofcv.abst.fiducial.calib.ConfigECoCheckMarkers;
import boofcv.abst.geo.calibration.DetectMultiFiducialCalibration;
import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.fiducial.calib.ecocheck.ECoCheckDetector;
import boofcv.alg.fiducial.calib.ecocheck.ECoCheckFound;
import boofcv.alg.fiducial.calib.ecocheck.ECoCheckUtils;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.struct.geo.PointIndex2D_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageDimension;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.jetbrains.annotations.Nullable;

public class CalibrationDetectorMultiECoCheck
implements DetectMultiFiducialCalibration {
    ECoCheckDetector<GrayF32> detector;
    List<ConfigECoCheckMarkers.MarkerShape> markers;
    ImageDimension dimension = new ImageDimension();
    TIntObjectMap<List<Point2D_F64>> cacheLayouts = new TIntObjectHashMap();

    public CalibrationDetectorMultiECoCheck(ECoCheckDetector<GrayF32> detector, List<ConfigECoCheckMarkers.MarkerShape> markers) {
        this.detector = detector;
        this.markers = markers;
    }

    public void process(GrayF32 input) {
        this.detector.process(input);
        this.dimension.setTo(input.width, input.height);
    }

    public int getDetectionCount() {
        return this.detector.getFound().size;
    }

    public int getMarkerID(int detectionID) {
        return ((ECoCheckFound)this.detector.getFound().get((int)detectionID)).markerID;
    }

    public int getTotalUniqueMarkers() {
        return this.detector.getUtils().markers.size();
    }

    public CalibrationObservation getDetectedPoints(int detectionID) {
        DogArray<PointIndex2D_F64> original = ((ECoCheckFound)this.detector.getFound().get((int)detectionID)).corners;
        CalibrationObservation found = new CalibrationObservation();
        for (int i = 0; i < original.size; ++i) {
            found.points.add(((PointIndex2D_F64)original.get(i)).copy());
        }
        return found;
    }

    public List<Point2D_F64> getLayout(int markerID) {
        ArrayList<Point2D_F64> layout = (ArrayList<Point2D_F64>)this.cacheLayouts.get(markerID);
        if (layout != null) {
            return layout;
        }
        ECoCheckUtils utils = this.detector.getUtils();
        ConfigECoCheckMarkers.MarkerShape shape = this.markers.get(markerID);
        Point3D_F64 p = new Point3D_F64();
        layout = new ArrayList<Point2D_F64>();
        int numCorners = shape.getNumCorners();
        for (int cornerID = 0; cornerID < numCorners; ++cornerID) {
            utils.cornerToMarker3D(markerID, cornerID, shape.squareSize, p);
            layout.add(cornerID, new Point2D_F64(p.x, p.y));
        }
        this.cacheLayouts.put(markerID, layout);
        return layout;
    }

    public void setLensDistortion(@Nullable LensDistortionNarrowFOV distortion, int width, int height) {
        throw new IllegalArgumentException("Not handled yet");
    }

    public ECoCheckDetector<GrayF32> getDetector() {
        return this.detector;
    }

    public List<ConfigECoCheckMarkers.MarkerShape> getMarkers() {
        return this.markers;
    }
}

