/*
 * Decompiled with CFR 0.152.
 */
package boofcv.deepboof;

import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.PixelTransformAffine_F32;
import boofcv.alg.interpolate.InterpolatePixel;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.core.image.border.BorderType;
import boofcv.factory.distort.FactoryDistort;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.distort.PixelTransform2_F32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.struct.affine.Affine2D_F32;

public class ClipAndReduce<T extends ImageBase<T>> {
    T clipped;
    Affine2D_F32 transform = new Affine2D_F32();
    ImageDistort<T, T> distort;
    boolean clip;

    public ClipAndReduce(boolean clip, ImageType<T> imageType) {
        this.clip = clip;
        InterpolatePixel interp = FactoryInterpolation.createPixel((double)0.0, (double)255.0, (InterpolationType)InterpolationType.BILINEAR, (BorderType)BorderType.EXTENDED, imageType);
        this.distort = FactoryDistort.distort((boolean)false, (InterpolatePixel)interp, imageType);
        this.distort.setModel((PixelTransform2_F32)new PixelTransformAffine_F32(this.transform));
    }

    public void massage(T input, T output) {
        if (this.clip) {
            T inputAdjusted = this.clipInput(input, output);
            this.transform.a11 = (float)((ImageBase)input).width / (float)((ImageBase)output).width;
            this.transform.a22 = (float)((ImageBase)input).height / (float)((ImageBase)output).height;
            this.distort.apply(inputAdjusted, output);
        } else {
            this.transform.a11 = (float)((ImageBase)input).width / (float)((ImageBase)output).width;
            this.transform.a22 = (float)((ImageBase)input).height / (float)((ImageBase)output).height;
            this.distort.apply(input, output);
        }
    }

    T clipInput(T input, T output) {
        double ratioInput = (double)((ImageBase)input).width / (double)((ImageBase)input).height;
        double ratioOutput = (double)((ImageBase)output).width / (double)((ImageBase)output).height;
        T a = input;
        if (ratioInput > ratioOutput) {
            int width = ((ImageBase)input).height * ((ImageBase)output).width / ((ImageBase)output).height;
            int x0 = (((ImageBase)input).width - width) / 2;
            int x1 = x0 + width;
            this.clipped = input.subimage(x0, 0, x1, ((ImageBase)input).height, this.clipped);
            a = this.clipped;
        } else if (ratioInput < ratioOutput) {
            int height = ((ImageBase)input).width * ((ImageBase)output).height / ((ImageBase)output).width;
            int y0 = (((ImageBase)input).height - height) / 2;
            int y1 = y0 + height;
            this.clipped = input.subimage(0, y0, ((ImageBase)input).width, y1, this.clipped);
            a = this.clipped;
        }
        return a;
    }
}

