/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.squares;

import boofcv.alg.fiducial.calib.squares.SquareEdge;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import org.ddogleg.struct.GrowQueue_B;

public class SquareNode {
    public static final int RESET_GRAPH = -2;
    public Polygon2D_F64 corners;
    public GrowQueue_B touch;
    public Point2D_F64 center = new Point2D_F64();
    public double[] sideLengths = new double[4];
    public double largestSide;
    public int graph;
    public SquareEdge[] edges = new SquareEdge[4];

    public double distanceSqCorner(Point2D_F64 p) {
        double best = Double.MAX_VALUE;
        for (int i = 0; i < 4; ++i) {
            double d = this.corners.get(i).distance2((GeoTuple2D_F64)p);
            if (!(d < best)) continue;
            best = d;
        }
        return best;
    }

    public void reset() {
        this.corners = null;
        this.touch = null;
        this.center.set(-1.0, -1.0);
        this.largestSide = 0.0;
        this.graph = -2;
        for (int i = 0; i < this.edges.length; ++i) {
            if (this.edges[i] != null) {
                throw new RuntimeException("BUG!");
            }
            this.sideLengths[i] = 0.0;
        }
    }

    public void updateArrayLength() {
        if (this.edges.length < this.corners.size()) {
            this.edges = new SquareEdge[this.corners.size()];
            this.sideLengths = new double[this.corners.size()];
        }
    }

    public int getNumberOfConnections() {
        int ret = 0;
        for (int i = 0; i < this.corners.size(); ++i) {
            if (this.edges[i] == null) continue;
            ++ret;
        }
        return ret;
    }

    public double smallestSideLength() {
        double smallest = Double.MAX_VALUE;
        for (int i = 0; i < this.corners.size(); ++i) {
            double length = this.sideLengths[i];
            if (!(length < smallest)) continue;
            smallest = length;
        }
        return smallest;
    }
}

