/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.circle;

import boofcv.alg.fiducial.calib.circle.EllipsesIntoClusters;
import georegression.metric.UtilAngle;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.EllipseRotated_F64;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.ddogleg.sorting.QuickSortComparator;
import org.ddogleg.struct.FastQueue;

public abstract class EllipseClustersIntoGrid {
    protected FastQueue<Grid> foundGrids = new FastQueue(Grid.class, true);
    protected static double MAX_LINE_ANGLE_CHANGE = UtilAngle.degreeToRadian((float)10.0f);
    protected FastQueue<NodeInfo> listInfo = new FastQueue(NodeInfo.class, true);
    protected QuickSortComparator<Edge> sorter;
    protected FastQueue<NodeInfo> contour = new FastQueue(NodeInfo.class, false);
    protected boolean verbose = false;

    public EllipseClustersIntoGrid() {
        this.sorter = new QuickSortComparator((Comparator)new Comparator<Edge>(){

            @Override
            public int compare(Edge o1, Edge o2) {
                if (o1.angle < o2.angle) {
                    return -1;
                }
                if (o1.angle > o2.angle) {
                    return 1;
                }
                return 0;
            }
        });
    }

    public abstract void process(List<EllipseRotated_F64> var1, List<List<EllipsesIntoClusters.Node>> var2);

    protected static List<NodeInfo> findLine(NodeInfo seed, NodeInfo next, int clusterSize) {
        if (next == null) {
            return null;
        }
        double anglePrev = EllipseClustersIntoGrid.direction(seed, next);
        ArrayList<NodeInfo> line = new ArrayList<NodeInfo>();
        line.add(seed);
        line.add(next);
        for (int i = 0; i < clusterSize + 1; ++i) {
            double bestScore = Double.MAX_VALUE;
            double bestDistance = Double.MAX_VALUE;
            double bestAngle = Double.NaN;
            double closestDistance = Double.MAX_VALUE;
            NodeInfo best = null;
            for (int j = 0; j < next.edges.size(); ++j) {
                double angle = ((Edge)next.edges.get((int)j)).angle;
                NodeInfo c = ((Edge)next.edges.get((int)j)).target;
                double diff = UtilAngle.dist((double)angle, (double)anglePrev);
                if (!(diff <= MAX_LINE_ANGLE_CHANGE)) continue;
                double d = c.ellipse.center.distance((GeoTuple2D_F64)next.ellipse.center);
                double score = (diff + 0.01) * d;
                if (score < bestScore) {
                    bestDistance = d;
                    bestScore = score;
                    bestAngle = angle;
                    best = c;
                }
                closestDistance = Math.min(d, closestDistance);
            }
            if (best == null || bestDistance > closestDistance * 2.0) {
                return line;
            }
            line.add(best);
            anglePrev = bestAngle;
            next = best;
        }
        throw new RuntimeException("Stuck in a loop?  Maximum line length exceeded");
    }

    protected static NodeInfo selectSeedNext(NodeInfo prevSeed, NodeInfo prevNext, NodeInfo currentSeed) {
        double angleTarget = EllipseClustersIntoGrid.direction(prevSeed, prevNext);
        double bestScore = Double.MAX_VALUE;
        NodeInfo best = null;
        Point2D_F64 c = currentSeed.ellipse.center;
        for (int i = 0; i < currentSeed.edges.size(); ++i) {
            double score;
            Edge edge = (Edge)currentSeed.edges.get(i);
            double angleDiff = UtilAngle.dist((double)edge.angle, (double)angleTarget);
            if (angleDiff > MAX_LINE_ANGLE_CHANGE * 1.5 || !((score = (angleDiff + 0.001) * c.distance((GeoTuple2D_F64)edge.target.ellipse.center)) < bestScore)) continue;
            bestScore = score;
            best = edge.target;
        }
        return best;
    }

    protected static NodeInfo findClosestEdge(NodeInfo n, Point2D_F64 p) {
        double bestDistance = Double.MAX_VALUE;
        NodeInfo best = null;
        for (int i = 0; i < n.edges.size(); ++i) {
            Edge e = (Edge)n.edges.get(i);
            double d = e.target.ellipse.center.distance2((GeoTuple2D_F64)p);
            if (!(d < bestDistance)) continue;
            bestDistance = d;
            best = e.target;
        }
        return best;
    }

    boolean checkDuplicates(List<List<NodeInfo>> grid) {
        for (int i = 0; i < grid.size(); ++i) {
            List<NodeInfo> list = grid.get(i);
            for (int j = 0; j < list.size(); ++j) {
                NodeInfo n = list.get(j);
                if (n.marked) {
                    return true;
                }
                n.marked = true;
            }
        }
        return false;
    }

    static double direction(NodeInfo seed, NodeInfo next) {
        return Math.atan2(next.ellipse.center.y - seed.ellipse.center.y, next.ellipse.center.x - seed.ellipse.center.x);
    }

    void computeNodeInfo(List<EllipseRotated_F64> ellipses, List<EllipsesIntoClusters.Node> cluster) {
        this.listInfo.reset();
        for (int i = 0; i < cluster.size(); ++i) {
            EllipsesIntoClusters.Node n = cluster.get(i);
            EllipseRotated_F64 t = ellipses.get(n.which);
            NodeInfo info = (NodeInfo)this.listInfo.grow();
            info.reset();
            info.ellipse = t;
        }
        this.addEdgesToInfo(cluster);
        this.pruneNearlyIdenticalAngles();
        this.findLargestAnglesForAllNodes();
    }

    void addEdgesToInfo(List<EllipsesIntoClusters.Node> cluster) {
        for (int i = 0; i < cluster.size(); ++i) {
            EllipsesIntoClusters.Node n = cluster.get(i);
            NodeInfo infoA = (NodeInfo)this.listInfo.get(i);
            EllipseRotated_F64 a = infoA.ellipse;
            for (int j = 0; j < n.connections.size(); ++j) {
                NodeInfo infoB = (NodeInfo)this.listInfo.get(EllipseClustersIntoGrid.indexOf(cluster, n.connections.get(j)));
                EllipseRotated_F64 b = infoB.ellipse;
                Edge edge = (Edge)infoA.edges.grow();
                edge.target = infoB;
                edge.angle = Math.atan2(b.center.y - a.center.y, b.center.x - a.center.x);
            }
            this.sorter.sort(infoA.edges.data, infoA.edges.size);
        }
    }

    void pruneNearlyIdenticalAngles() {
        for (int i = 0; i < this.listInfo.size(); ++i) {
            NodeInfo infoN = (NodeInfo)this.listInfo.get(i);
            int j = 0;
            while (j < infoN.edges.size()) {
                int k = (j + 1) % infoN.edges.size;
                double angularDiff = UtilAngle.dist((double)((Edge)infoN.edges.get((int)j)).angle, (double)((Edge)infoN.edges.get((int)k)).angle);
                if (angularDiff < (double)UtilAngle.radian((float)5.0f)) {
                    double distK;
                    NodeInfo infoJ = ((Edge)infoN.edges.get((int)j)).target;
                    NodeInfo infoK = ((Edge)infoN.edges.get((int)k)).target;
                    double distJ = infoN.ellipse.center.distance((GeoTuple2D_F64)infoJ.ellipse.center);
                    if (distJ < (distK = infoN.ellipse.center.distance((GeoTuple2D_F64)infoK.ellipse.center))) {
                        infoN.edges.remove(k);
                        continue;
                    }
                    infoN.edges.remove(j);
                    continue;
                }
                ++j;
            }
        }
    }

    void findLargestAnglesForAllNodes() {
        for (int i = 0; i < this.listInfo.size(); ++i) {
            NodeInfo info = (NodeInfo)this.listInfo.get(i);
            if (info.edges.size < 2) continue;
            int k = 0;
            int j = info.edges.size - 1;
            while (k < info.edges.size) {
                double angleA = ((Edge)info.edges.get((int)j)).angle;
                double angleB = ((Edge)info.edges.get((int)k)).angle;
                double distance = UtilAngle.distanceCCW((double)angleA, (double)angleB);
                if (distance > info.angleBetween) {
                    info.angleBetween = distance;
                    info.left = ((Edge)info.edges.get((int)j)).target;
                    info.right = ((Edge)info.edges.get((int)k)).target;
                }
                j = k++;
            }
        }
    }

    boolean findContour(boolean mustHaveInner) {
        NodeInfo seed = (NodeInfo)this.listInfo.get(0);
        for (int i = 1; i < this.listInfo.size(); ++i) {
            NodeInfo info = (NodeInfo)this.listInfo.get(i);
            if (!(info.angleBetween > seed.angleBetween)) continue;
            seed = info;
        }
        this.contour.reset();
        this.contour.add((Object)seed);
        seed.contour = true;
        NodeInfo prev = seed;
        NodeInfo current = seed.right;
        while (current != null && current != seed && this.contour.size() < this.listInfo.size()) {
            if (prev != current.left) {
                return false;
            }
            this.contour.add((Object)current);
            current.contour = true;
            prev = current;
            current = current.right;
        }
        return this.contour.size >= 4 && (!mustHaveInner || this.contour.size < this.listInfo.size());
    }

    public static int indexOf(List<EllipsesIntoClusters.Node> list, int value) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get((int)i).which != value) continue;
            return i;
        }
        return -1;
    }

    NodeInfo selectSeedCorner() {
        NodeInfo best = null;
        double bestError = Double.MAX_VALUE;
        for (int i = 0; i < this.contour.size; ++i) {
            NodeInfo info = (NodeInfo)this.contour.get(i);
            double error = UtilAngle.dist((double)4.71238898038469, (double)info.angleBetween);
            if (!(error < bestError)) continue;
            bestError = error;
            best = info;
        }
        return best;
    }

    public FastQueue<Grid> getGrids() {
        return this.foundGrids;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public static class Grid {
        public List<EllipseRotated_F64> ellipses = new ArrayList<EllipseRotated_F64>();
        public int rows;
        public int columns;

        public void reset() {
            this.columns = -1;
            this.rows = -1;
            this.ellipses.clear();
        }

        public EllipseRotated_F64 get(int row, int col) {
            return this.ellipses.get(row * this.columns + col);
        }

        public int idx(int row, int col) {
            return row * this.columns + col;
        }

        public void setShape(int rows, int columns) {
            this.rows = rows;
            this.columns = columns;
        }

        public int getIndexOfAsymEllipse(int row, int col) {
            int index = 0;
            return (index += row / 2 * this.columns + row % 2 * (this.columns / 2 + this.columns % 2)) + col / 2;
        }

        public int getIndexOfRegEllipse(int row, int col) {
            return row * this.columns + col;
        }
    }

    public static class Edge {
        NodeInfo target;
        double angle;
    }

    public static class NodeInfo {
        EllipseRotated_F64 ellipse;
        FastQueue<Edge> edges = new FastQueue(Edge.class, true);
        boolean contour;
        NodeInfo left;
        NodeInfo right;
        double angleBetween;
        boolean marked;

        public void reset() {
            this.contour = false;
            this.ellipse = null;
            this.right = null;
            this.left = null;
            this.angleBetween = 0.0;
            this.marked = false;
            this.edges.reset();
        }
    }
}

