/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.circle;

import boofcv.alg.fiducial.calib.circle.EllipseClustersIntoGrid;
import boofcv.alg.fiducial.calib.circle.EllipsesIntoClusters;
import georegression.metric.Intersection2D_F64;
import georegression.struct.line.LineSegment2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.EllipseRotated_F64;
import java.util.ArrayList;
import java.util.List;

public class EllipseClustersIntoAsymmetricGrid
extends EllipseClustersIntoGrid {
    private LineSegment2D_F64 line0110 = new LineSegment2D_F64();
    private LineSegment2D_F64 line0011 = new LineSegment2D_F64();
    private Point2D_F64 intersection = new Point2D_F64();

    @Override
    public void process(List<EllipseRotated_F64> ellipses, List<List<EllipsesIntoClusters.Node>> clusters) {
        this.foundGrids.reset();
        for (int i = 0; i < clusters.size(); ++i) {
            List<EllipsesIntoClusters.Node> cluster = clusters.get(i);
            int clusterSize = cluster.size();
            this.computeNodeInfo(ellipses, cluster);
            if (!this.findContour(true)) {
                if (!this.verbose) continue;
                System.out.println("Contour find failed");
                continue;
            }
            EllipseClustersIntoGrid.NodeInfo corner = this.selectSeedCorner();
            List<EllipseClustersIntoGrid.NodeInfo> cornerRow = EllipseClustersIntoAsymmetricGrid.findLine(corner, corner.left, clusterSize);
            List<EllipseClustersIntoGrid.NodeInfo> cornerColumn = EllipseClustersIntoAsymmetricGrid.findLine(corner, corner.right, clusterSize);
            ArrayList<List<EllipseClustersIntoGrid.NodeInfo>> outerGrid = new ArrayList<List<EllipseClustersIntoGrid.NodeInfo>>();
            outerGrid.add(cornerRow);
            boolean failed = false;
            for (int j = 1; j < cornerColumn.size(); ++j) {
                List prev = (List)outerGrid.get(j - 1);
                EllipseClustersIntoGrid.NodeInfo seed = cornerColumn.get(j);
                EllipseClustersIntoGrid.NodeInfo next = EllipseClustersIntoAsymmetricGrid.selectSeedNext((EllipseClustersIntoGrid.NodeInfo)prev.get(0), (EllipseClustersIntoGrid.NodeInfo)prev.get(1), seed);
                if (next == null) {
                    if (this.verbose) {
                        System.out.println("Outer column with a row that has only one element");
                    }
                    failed = true;
                    break;
                }
                List<EllipseClustersIntoGrid.NodeInfo> row = EllipseClustersIntoAsymmetricGrid.findLine(seed, next, clusterSize);
                outerGrid.add(row);
            }
            if (failed) continue;
            List<List<EllipseClustersIntoGrid.NodeInfo>> innerGrid = this.findInnerGrid(outerGrid, clusterSize);
            if (innerGrid == null) {
                if (!this.verbose) continue;
                System.out.println("Inner grid find failed");
                continue;
            }
            if (!EllipseClustersIntoAsymmetricGrid.checkGridSize(outerGrid, innerGrid, cluster.size())) {
                int j;
                if (!this.verbose) continue;
                System.out.println("grid size check failed");
                for (j = 0; j < outerGrid.size(); ++j) {
                    System.out.println("  outer row " + ((List)outerGrid.get(j)).size());
                }
                for (j = 0; j < innerGrid.size(); ++j) {
                    System.out.println("  inner row " + innerGrid.get(j).size());
                }
                continue;
            }
            if (this.checkDuplicates(outerGrid) || this.checkDuplicates(innerGrid)) {
                if (!this.verbose) continue;
                System.out.println("contains duplicates");
                continue;
            }
            this.combineGrids(outerGrid, innerGrid);
        }
    }

    protected EllipseClustersIntoGrid.NodeInfo selectInnerSeed(EllipseClustersIntoGrid.NodeInfo c00, EllipseClustersIntoGrid.NodeInfo c01, EllipseClustersIntoGrid.NodeInfo c10, EllipseClustersIntoGrid.NodeInfo c11) {
        EllipseClustersIntoGrid.NodeInfo b;
        this.line0110.a.set(c01.ellipse.center);
        this.line0110.b.set(c10.ellipse.center);
        this.line0011.a.set(c00.ellipse.center);
        this.line0011.b.set(c11.ellipse.center);
        if (null == Intersection2D_F64.intersection((LineSegment2D_F64)this.line0110, (LineSegment2D_F64)this.line0011, (Point2D_F64)this.intersection)) {
            return null;
        }
        EllipseClustersIntoGrid.NodeInfo a = EllipseClustersIntoAsymmetricGrid.findClosestEdge(c00, this.intersection);
        if (a == (b = EllipseClustersIntoAsymmetricGrid.findClosestEdge(c11, this.intersection))) {
            return a;
        }
        return null;
    }

    static boolean checkGridSize(List<List<EllipseClustersIntoGrid.NodeInfo>> outerGrid, List<List<EllipseClustersIntoGrid.NodeInfo>> innerGrid, int clusterSize) {
        int i;
        int total = 0;
        int expected = outerGrid.get(0).size();
        for (i = 0; i < outerGrid.size(); ++i) {
            if (expected != outerGrid.get(i).size()) {
                return false;
            }
            total += outerGrid.get(i).size();
        }
        expected = innerGrid.get(0).size();
        for (i = 0; i < innerGrid.size(); ++i) {
            if (expected != innerGrid.get(i).size()) {
                return false;
            }
            total += innerGrid.get(i).size();
        }
        return total == clusterSize;
    }

    void combineGrids(List<List<EllipseClustersIntoGrid.NodeInfo>> outerGrid, List<List<EllipseClustersIntoGrid.NodeInfo>> innerGrid) {
        EllipseClustersIntoGrid.Grid g = (EllipseClustersIntoGrid.Grid)this.foundGrids.grow();
        g.reset();
        g.columns = outerGrid.get(0).size() + innerGrid.get(0).size();
        g.rows = outerGrid.size() + innerGrid.size();
        for (int row = 0; row < g.rows; ++row) {
            List<EllipseClustersIntoGrid.NodeInfo> list = row % 2 == 0 ? outerGrid.get(row / 2) : innerGrid.get(row / 2);
            for (int i = 0; i < g.columns; ++i) {
                if (i % 2 == row % 2) {
                    g.ellipses.add(list.get((int)(i / 2)).ellipse);
                    continue;
                }
                g.ellipses.add(null);
            }
        }
    }

    List<List<EllipseClustersIntoGrid.NodeInfo>> findInnerGrid(List<List<EllipseClustersIntoGrid.NodeInfo>> outerGrid, int clusterSize) {
        EllipseClustersIntoGrid.NodeInfo c11;
        EllipseClustersIntoGrid.NodeInfo c10;
        EllipseClustersIntoGrid.NodeInfo c01;
        EllipseClustersIntoGrid.NodeInfo c00 = outerGrid.get(0).get(0);
        EllipseClustersIntoGrid.NodeInfo corner = this.selectInnerSeed(c00, c01 = outerGrid.get(0).get(1), c10 = outerGrid.get(1).get(0), c11 = outerGrid.get(1).get(1));
        if (corner == null) {
            if (this.verbose) {
                System.out.println("Can't select inner grid seed");
            }
            return null;
        }
        EllipseClustersIntoGrid.NodeInfo rowNext = EllipseClustersIntoAsymmetricGrid.selectSeedNext(c00, c01, corner);
        EllipseClustersIntoGrid.NodeInfo colNext = EllipseClustersIntoAsymmetricGrid.selectSeedNext(c00, c10, corner);
        List<EllipseClustersIntoGrid.NodeInfo> row = EllipseClustersIntoAsymmetricGrid.findLine(corner, rowNext, clusterSize);
        List<EllipseClustersIntoGrid.NodeInfo> column = EllipseClustersIntoAsymmetricGrid.findLine(corner, colNext, clusterSize);
        ArrayList<List<EllipseClustersIntoGrid.NodeInfo>> grid = new ArrayList<List<EllipseClustersIntoGrid.NodeInfo>>();
        if (row != null && column != null) {
            grid.add(row);
            for (int i = 1; i < column.size(); ++i) {
                EllipseClustersIntoGrid.NodeInfo next;
                List prev = (List)grid.get(i - 1);
                EllipseClustersIntoGrid.NodeInfo seed = column.get(i);
                row = EllipseClustersIntoAsymmetricGrid.findLine(seed, next = EllipseClustersIntoAsymmetricGrid.selectSeedNext((EllipseClustersIntoGrid.NodeInfo)prev.get(0), (EllipseClustersIntoGrid.NodeInfo)prev.get(1), seed), clusterSize);
                if (row == null) {
                    if (this.verbose) {
                        System.out.println("Inner grid missing a row");
                    }
                    return null;
                }
                grid.add(row);
            }
        } else if (row != null) {
            grid.add(row);
        } else if (column != null) {
            for (int i = 0; i < column.size(); ++i) {
                ArrayList<EllipseClustersIntoGrid.NodeInfo> l = new ArrayList<EllipseClustersIntoGrid.NodeInfo>();
                l.add(column.get(i));
                grid.add(l);
            }
        } else {
            row = new ArrayList<EllipseClustersIntoGrid.NodeInfo>();
            row.add(corner);
            grid.add(row);
        }
        return grid;
    }
}

