/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.circle;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.fiducial.calib.circle.EllipseClustersIntoGrid;
import boofcv.alg.fiducial.calib.circle.EllipsesIntoClusters;
import boofcv.alg.shapes.ellipse.BinaryEllipseDetector;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.EllipseRotated_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueue;

public abstract class DetectCircleGrid<T extends ImageGray<T>> {
    private BinaryEllipseDetector<T> ellipseDetector;
    private InputToBinary<T> inputToBinary;
    private GrayU8 binary = new GrayU8(1, 1);
    protected int numRows;
    protected int numCols;
    private EllipsesIntoClusters clustering;
    private EllipseClustersIntoGrid grider;
    private List<EllipseClustersIntoGrid.Grid> validGrids = new ArrayList<EllipseClustersIntoGrid.Grid>();
    private List<EllipseRotated_F64> work = new ArrayList<EllipseRotated_F64>();
    private List<List<EllipsesIntoClusters.Node>> clusters = new ArrayList<List<EllipsesIntoClusters.Node>>();
    private List<List<EllipsesIntoClusters.Node>> clustersPruned = new ArrayList<List<EllipsesIntoClusters.Node>>();
    private boolean verbose = false;

    public DetectCircleGrid(int numRows, int numCols, InputToBinary<T> inputToBinary, BinaryEllipseDetector<T> ellipseDetector, EllipsesIntoClusters clustering, EllipseClustersIntoGrid grider) {
        this.ellipseDetector = ellipseDetector;
        this.inputToBinary = inputToBinary;
        this.numRows = numRows;
        this.numCols = numCols;
        this.clustering = clustering;
        this.grider = grider;
    }

    public void process(T gray) {
        if (this.verbose) {
            System.out.println("ENTER DetectAsymmetricCircleGrid.process()");
        }
        this.binary.reshape(((ImageGray)gray).width, ((ImageGray)gray).height);
        this.inputToBinary.process(gray, (ImageBase)this.binary);
        this.ellipseDetector.process(gray, this.binary);
        List found = this.ellipseDetector.getFoundEllipses().toList();
        if (this.verbose) {
            System.out.println("  Found " + found.size() + " ellpises");
        }
        this.clusters.clear();
        this.clustering.process(found, this.clusters);
        this.clustersPruned.clear();
        this.clustersPruned.addAll(this.clusters);
        if (this.verbose) {
            System.out.println("  Found " + this.clusters.size() + " clusters");
        }
        DetectCircleGrid.pruneIncorrectSize(this.clustersPruned, this.totalEllipses(this.numRows, this.numCols));
        if (this.verbose) {
            System.out.println("  Remaining clusters after pruning by size " + this.clustersPruned.size());
        }
        this.grider.process(found, this.clustersPruned);
        FastQueue<EllipseClustersIntoGrid.Grid> grids = this.grider.getGrids();
        if (this.verbose) {
            System.out.println("  Found " + grids.size() + " grids");
        }
        DetectCircleGrid.pruneIncorrectShape(grids, this.numRows, this.numCols);
        if (this.verbose) {
            System.out.println("  Remaining grids after pruning by shape " + grids.size());
        }
        this.validGrids.clear();
        for (int i = 0; i < grids.size(); ++i) {
            EllipseClustersIntoGrid.Grid g = (EllipseClustersIntoGrid.Grid)grids.get(i);
            this.putGridIntoCanonical(g);
            this.validGrids.add(g);
        }
        if (this.verbose) {
            System.out.println("EXIT DetectAsymmetricCircleGrid.process()");
        }
    }

    protected abstract int totalEllipses(int var1, int var2);

    protected abstract void putGridIntoCanonical(EllipseClustersIntoGrid.Grid var1);

    static int closestCorner4(EllipseClustersIntoGrid.Grid g) {
        double bestDistance = g.get((int)0, (int)0).center.normSq();
        int bestIdx = 0;
        double d = g.get((int)0, (int)(g.columns - 1)).center.normSq();
        if (d < bestDistance) {
            bestDistance = d;
            bestIdx = 3;
        }
        if ((d = g.get((int)(g.rows - 1), (int)(g.columns - 1)).center.normSq()) < bestDistance) {
            bestDistance = d;
            bestIdx = 2;
        }
        if ((d = g.get((int)(g.rows - 1), (int)0).center.normSq()) < bestDistance) {
            bestIdx = 1;
        }
        return bestIdx;
    }

    void rotateGridCCW(EllipseClustersIntoGrid.Grid g) {
        this.work.clear();
        for (int i = 0; i < g.rows * g.columns; ++i) {
            this.work.add(null);
        }
        for (int row = 0; row < g.rows; ++row) {
            for (int col = 0; col < g.columns; ++col) {
                this.work.set(col * g.rows + row, g.get(g.rows - row - 1, col));
            }
        }
        g.ellipses.clear();
        g.ellipses.addAll(this.work);
        int tmp = g.columns;
        g.columns = g.rows;
        g.rows = tmp;
    }

    void reverse(EllipseClustersIntoGrid.Grid g) {
        this.work.clear();
        int N = g.rows * g.columns;
        for (int i = 0; i < N; ++i) {
            this.work.add(g.ellipses.get(N - i - 1));
        }
        g.ellipses.clear();
        g.ellipses.addAll(this.work);
    }

    void flipHorizontal(EllipseClustersIntoGrid.Grid g) {
        this.work.clear();
        for (int row = 0; row < g.rows; ++row) {
            for (int col = 0; col < g.columns; ++col) {
                this.work.add(g.get(row, g.columns - col - 1));
            }
        }
        g.ellipses.clear();
        g.ellipses.addAll(this.work);
    }

    void flipVertical(EllipseClustersIntoGrid.Grid g) {
        this.work.clear();
        for (int row = 0; row < g.rows; ++row) {
            for (int col = 0; col < g.columns; ++col) {
                this.work.add(g.get(g.rows - row - 1, col));
            }
        }
        g.ellipses.clear();
        g.ellipses.addAll(this.work);
    }

    static void pruneIncorrectShape(FastQueue<EllipseClustersIntoGrid.Grid> grids, int numRows, int numCols) {
        for (int i = grids.size() - 1; i >= 0; --i) {
            EllipseClustersIntoGrid.Grid g = (EllipseClustersIntoGrid.Grid)grids.get(i);
            if (g.rows == numRows && g.columns == numCols || g.rows == numCols && g.columns == numRows) continue;
            grids.remove(i);
        }
    }

    static void pruneIncorrectSize(List<List<EllipsesIntoClusters.Node>> clusters, int N) {
        for (int i = clusters.size() - 1; i >= 0; --i) {
            if (clusters.get(i).size() == N) continue;
            clusters.remove(i);
        }
    }

    public BinaryEllipseDetector<T> getEllipseDetector() {
        return this.ellipseDetector;
    }

    public EllipseClustersIntoGrid getGrider() {
        return this.grider;
    }

    public EllipsesIntoClusters getClustering() {
        return this.clustering;
    }

    public List<List<EllipsesIntoClusters.Node>> getClusters() {
        return this.clusters;
    }

    public List<List<EllipsesIntoClusters.Node>> getClustersPruned() {
        return this.clustersPruned;
    }

    public List<EllipseClustersIntoGrid.Grid> getGrids() {
        return this.validGrids;
    }

    public List<Point2D_F64> getCalibrationPoints() {
        return null;
    }

    public GrayU8 getBinary() {
        return this.binary;
    }

    public int getColumns() {
        return this.numCols;
    }

    public int getRows() {
        return this.numRows;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.ellipseDetector.setVerbose(verbose);
        this.grider.setVerbose(verbose);
        this.verbose = verbose;
    }
}

