/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.chess;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.fiducial.calib.chess.ChessboardPolygonHelper;
import boofcv.alg.fiducial.calib.chess.DetectChessSquarePoints;
import boofcv.alg.filter.binary.BinaryImageOps;
import boofcv.alg.shapes.polygon.BinaryPolygonDetector;
import boofcv.alg.shapes.polygon.RefineBinaryPolygon;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F64;
import java.util.List;

public class DetectChessboardFiducial<T extends ImageGray<T>> {
    private DetectChessSquarePoints<T> findSeeds;
    private GrayU8 binary = new GrayU8(1, 1);
    private GrayU8 eroded = new GrayU8(1, 1);
    private int numRows;
    private int numCols;
    InputToBinary<T> inputToBinary;

    public DetectChessboardFiducial(int numRows, int numCols, double maxCornerDistance, BinaryPolygonDetector<T> detectorSquare, RefineBinaryPolygon<T> refineLine, RefineBinaryPolygon<T> refineCorner, InputToBinary<T> inputToBinary) {
        this.numRows = numRows;
        this.numCols = numCols;
        this.inputToBinary = inputToBinary;
        this.findSeeds = new DetectChessSquarePoints<T>(numRows, numCols, maxCornerDistance, detectorSquare);
        detectorSquare.setHelper(new ChessboardPolygonHelper<T>(detectorSquare, refineLine, refineCorner));
        this.reset();
    }

    public void reset() {
    }

    public boolean process(T gray) {
        this.binary.reshape(((ImageGray)gray).width, ((ImageGray)gray).height);
        this.eroded.reshape(((ImageGray)gray).width, ((ImageGray)gray).height);
        this.inputToBinary.process(gray, (ImageBase)this.binary);
        BinaryImageOps.erode8((GrayU8)this.binary, (int)1, (GrayU8)this.eroded);
        return this.findSeeds.process(gray, this.eroded);
    }

    public DetectChessSquarePoints getFindSeeds() {
        return this.findSeeds;
    }

    public List<Point2D_F64> getCalibrationPoints() {
        return this.findSeeds.getCalibrationPoints().toList();
    }

    public GrayU8 getBinary() {
        return this.eroded;
    }

    public int getColumns() {
        return this.numCols;
    }

    public int getRows() {
        return this.numRows;
    }
}

