/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial.calib;

import boofcv.abst.fiducial.calib.ConfigCircleAsymmetricGrid;
import boofcv.abst.filter.binary.InputToBinary;
import boofcv.abst.geo.calibration.DetectorFiducialCalibration;
import boofcv.alg.fiducial.calib.circle.DetectCircleAsymmetricGrid;
import boofcv.alg.fiducial.calib.circle.EllipseClustersIntoGrid;
import boofcv.alg.fiducial.calib.circle.EllipsesIntoClusters;
import boofcv.alg.fiducial.calib.circle.KeyPointsCircleAsymmetricGrid;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.alg.shapes.ellipse.BinaryEllipseDetector;
import boofcv.factory.filter.binary.ConfigThreshold;
import boofcv.factory.filter.binary.FactoryThresholdBinary;
import boofcv.factory.shape.ConfigEllipseDetector;
import boofcv.factory.shape.FactoryShapeDetector;
import boofcv.struct.image.GrayF32;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueue;

public class CalibrationDetectorCircleAsymmGrid
implements DetectorFiducialCalibration {
    private DetectCircleAsymmetricGrid<GrayF32> detector;
    private KeyPointsCircleAsymmetricGrid keypoint = new KeyPointsCircleAsymmetricGrid();
    private List<Point2D_F64> layout;
    private CalibrationObservation results;
    double spaceToDiameter;

    public CalibrationDetectorCircleAsymmGrid(ConfigCircleAsymmetricGrid config) {
        InputToBinary inputToBinary = FactoryThresholdBinary.threshold((ConfigThreshold)config.thresholding, GrayF32.class);
        BinaryEllipseDetector ellipseDetector = FactoryShapeDetector.ellipse((ConfigEllipseDetector)config.ellipse, GrayF32.class);
        this.spaceToDiameter = config.centerDistance / config.circleDiameter;
        double spaceToRadius = 2.0 * this.spaceToDiameter;
        EllipsesIntoClusters e2c = new EllipsesIntoClusters(spaceToRadius * 1.25, config.ellipseSizeSimilarity);
        this.detector = new DetectCircleAsymmetricGrid(config.numRows, config.numCols, inputToBinary, ellipseDetector, e2c);
        this.layout = CalibrationDetectorCircleAsymmGrid.createLayout(this.detector.getRows(), this.detector.getColumns(), config.centerDistance);
    }

    public boolean process(GrayF32 input) {
        this.results = new CalibrationObservation();
        this.detector.process(input);
        List<EllipseClustersIntoGrid.Grid> grids = this.detector.getGrids();
        if (grids.size() != 1) {
            return false;
        }
        if (!this.keypoint.process(grids.get(0))) {
            return false;
        }
        FastQueue<Point2D_F64> foundPixels = this.keypoint.getKeyPoints();
        for (int i = 0; i < foundPixels.size; ++i) {
            this.results.add((Point2D_F64)foundPixels.get(i), i);
        }
        return true;
    }

    public CalibrationObservation getDetectedPoints() {
        return this.results;
    }

    public List<Point2D_F64> getLayout() {
        return this.layout;
    }

    public static List<Point2D_F64> createLayout(int numRows, int numCols, double centerDistance) {
        ArrayList<Point2D_F64> ret = new ArrayList<Point2D_F64>();
        double widthCell = centerDistance / 2.0;
        double width = (double)(numCols - 1) * widthCell;
        double height = (double)(numRows - 1) * widthCell;
        for (int row = 0; row < numRows; ++row) {
            double y = (double)(numRows - row - 1) * widthCell - height / 2.0;
            for (int col = 0; col < numCols; ++col) {
                double x = (double)col * widthCell - width / 2.0;
                if (row % 2 == 0 && col % 2 == 1 || row % 2 == 1 && col % 2 == 0) continue;
                ret.add(new Point2D_F64(x, y));
            }
        }
        return ret;
    }

    public DetectCircleAsymmetricGrid<GrayF32> getDetector() {
        return this.detector;
    }

    public KeyPointsCircleAsymmetricGrid getKeypointFinder() {
        return this.keypoint;
    }

    public int getRows() {
        return this.detector.getRows();
    }

    public int getColumns() {
        return this.detector.getColumns();
    }

    public double getSpaceToDiameter() {
        return this.spaceToDiameter;
    }
}

