/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial;

import boofcv.abst.fiducial.FiducialDetector;
import boofcv.abst.fiducial.FiducialStability;
import boofcv.abst.geo.Estimate1ofPnP;
import boofcv.abst.geo.RefinePnP;
import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.geo.Point2D3D;
import boofcv.struct.geo.PointIndex2D_F64;
import boofcv.struct.image.ImageBase;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.so.Rodrigues_F64;
import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrixRMaj;

public abstract class FiducialDetectorPnP<T extends ImageBase<T>>
implements FiducialDetector<T> {
    private LensDistortionNarrowFOV lensDistortion;
    private Point2Transform2_F64 pixelToNorm;
    private List<Point2D3D> detected2D3D = new ArrayList<Point2D3D>();
    private List<PointIndex2D_F64> detectedPixels;
    private Point2D_F64 workPt = new Point2D_F64();
    boolean hasCameraModel = false;
    private Estimate1ofPnP estimatePnP = FactoryMultiView.computePnPwithEPnP((int)10, (double)0.2);
    private RefinePnP refinePnP = FactoryMultiView.refinePnP((double)1.0E-8, (int)100);
    private Se3_F64 initialEstimate = new Se3_F64();
    private double maxLocation;
    private double maxOrientation;
    private Se3_F64 targetToCamera = new Se3_F64();
    private Se3_F64 targetToCameraSample = new Se3_F64();
    private Se3_F64 referenceCameraToTarget = new Se3_F64();
    private Se3_F64 difference = new Se3_F64();
    private Rodrigues_F64 rodrigues = new Rodrigues_F64();

    @Override
    public boolean computeStability(int which, double disturbance, FiducialStability results) {
        if (!this.getFiducialToCamera(which, this.targetToCamera)) {
            return false;
        }
        this.targetToCamera.invert(this.referenceCameraToTarget);
        this.maxOrientation = 0.0;
        this.maxLocation = 0.0;
        for (int i = 0; i < this.detected2D3D.size(); ++i) {
            this.estimatePose(which, this.detected2D3D, this.targetToCameraSample);
            this.referenceCameraToTarget.concat(this.targetToCameraSample, this.difference);
            Point2D3D p23 = this.detected2D3D.get(i);
            Point2D_F64 p = (Point2D_F64)this.detectedPixels.get(i);
            this.workPt.set(p);
            this.perturb(which, disturbance, this.workPt, p, p23);
        }
        results.location = this.maxLocation;
        results.orientation = this.maxOrientation;
        return true;
    }

    private void perturb(int which, double disturbance, Point2D_F64 pixel, Point2D_F64 original, Point2D3D p23) {
        pixel.x = original.x + disturbance;
        this.computeDisturbance(which, pixel, p23);
        pixel.x = original.x - disturbance;
        this.computeDisturbance(which, pixel, p23);
        pixel.y = original.y;
        pixel.y = original.y + disturbance;
        this.computeDisturbance(which, pixel, p23);
        pixel.y = original.y - disturbance;
        this.computeDisturbance(which, pixel, p23);
    }

    private void computeDisturbance(int which, Point2D_F64 pixel, Point2D3D p23) {
        this.pixelToNorm.compute(pixel.x, pixel.y, p23.observation);
        if (this.estimatePose(which, this.detected2D3D, this.targetToCameraSample)) {
            this.referenceCameraToTarget.concat(this.targetToCameraSample, this.difference);
            double d = this.difference.getT().norm();
            ConvertRotation3D_F64.matrixToRodrigues((DMatrixRMaj)this.difference.getR(), (Rodrigues_F64)this.rodrigues);
            double theta = Math.abs(this.rodrigues.theta);
            if (theta > this.maxOrientation) {
                this.maxOrientation = theta;
            }
            if (d > this.maxLocation) {
                this.maxLocation = d;
            }
        }
    }

    @Override
    public void setLensDistortion(LensDistortionNarrowFOV distortion) {
        if (distortion != null) {
            this.hasCameraModel = true;
            this.lensDistortion = distortion;
            this.pixelToNorm = this.lensDistortion.undistort_F64(true, false);
        } else {
            this.hasCameraModel = false;
            this.lensDistortion = null;
            this.pixelToNorm = null;
        }
    }

    @Override
    public LensDistortionNarrowFOV getLensDistortion() {
        return this.lensDistortion;
    }

    @Override
    public boolean getFiducialToCamera(int which, Se3_F64 fiducialToCamera) {
        if (!this.hasCameraModel) {
            return false;
        }
        this.detectedPixels = this.getDetectedControl(which);
        if (this.detectedPixels.size() < 3) {
            return false;
        }
        this.createDetectedList(which, this.detectedPixels);
        return this.estimatePose(which, this.detected2D3D, fiducialToCamera);
    }

    public void createDetectedList(int which, List<PointIndex2D_F64> pixels) {
        this.detected2D3D.clear();
        List<Point2D3D> all = this.getControl3D(which);
        for (int i = 0; i < pixels.size(); ++i) {
            PointIndex2D_F64 a = pixels.get(i);
            Point2D3D b = all.get(i);
            this.pixelToNorm.compute(a.x, a.y, b.observation);
            this.detected2D3D.add(b);
        }
    }

    protected boolean estimatePose(int which, List<Point2D3D> points, Se3_F64 fiducialToCamera) {
        return this.estimatePnP.process(points, (Object)this.initialEstimate) && this.refinePnP.fitModel(points, (Object)this.initialEstimate, (Object)fiducialToCamera);
    }

    protected abstract List<PointIndex2D_F64> getDetectedControl(int var1);

    protected abstract List<Point2D3D> getControl3D(int var1);

    @Override
    public boolean is3D() {
        return this.hasCameraModel;
    }
}

