/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct;

import boofcv.struct.ConfigGenerator;
import boofcv.struct.Configuration;
import java.util.HashMap;
import java.util.Map;

public abstract class ConfigGeneratorPatternSearchBase<Config extends Configuration>
extends ConfigGenerator<Config> {
    Map<String, Discretization> pathToRule = new HashMap<String, Discretization>();
    int rangeDiscretization = 10;
    protected Config configurationWork;

    protected ConfigGeneratorPatternSearchBase(long seed, Class<Config> type) {
        super(seed, type);
    }

    @Override
    protected int getNumberOfStates(ConfigGenerator.Parameter p) {
        if (p.getStateSize() != 0) {
            return p.getStateSize();
        }
        switch (this.pathToRule.getOrDefault(p.path, Discretization.DEFAULT)) {
            case DEFAULT: {
                if (p instanceof ConfigGenerator.RangeOfIntegers) {
                    ConfigGenerator.RangeOfIntegers pp = (ConfigGenerator.RangeOfIntegers)p;
                    int uniqueValues = pp.idx1 - pp.idx0 + 1;
                    return Math.min(uniqueValues, this.rangeDiscretization);
                }
                return this.rangeDiscretization;
            }
            case INTEGER_VALUES: {
                double val0 = ((Number)p.selectValue(0.0)).doubleValue();
                double val1 = ((Number)p.selectValue(1.0)).doubleValue();
                return (int)(val1 - val0 + 1.0);
            }
        }
        throw new RuntimeException("Unknown rule");
    }

    @Override
    public String toStringSettings() {
        Object ret = "Vector:\n";
        ret = (String)ret + "discretization," + this.rangeDiscretization + "\n";
        ret = (String)ret + super.toStringSettings();
        ret = (String)ret + "rules:\n";
        for (String key : this.pathToRule.keySet()) {
            ret = (String)ret + key + "," + (Object)((Object)this.pathToRule.get(key)) + "\n";
        }
        return ret;
    }

    public void setDiscretizationRule(String path, Discretization rule) {
        this.pathToRule.put(path, rule);
    }

    public int getRangeDiscretization() {
        return this.rangeDiscretization;
    }

    public void setRangeDiscretization(int rangeDiscretization) {
        this.rangeDiscretization = rangeDiscretization;
    }

    public static enum Discretization {
        DEFAULT,
        INTEGER_VALUES;

    }
}

