/*
 * Decompiled with CFR 0.152.
 */
package boofcv.javacv;

import boofcv.io.image.SimpleImageSequence;
import boofcv.io.wrapper.WebcamInterface;
import boofcv.javacv.ConvertOpenCvFrame;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameGrabber;
import org.bytedeco.javacv.OpenCVFrameGrabber;
import org.ddogleg.struct.DogArray_I8;

public class WebcamOpenCV
implements WebcamInterface {
    public <T extends ImageBase<T>> SimpleImageSequence<T> open(String device, int width, int height, ImageType<T> imageType) {
        OpenCVFrameGrabber grabber = null;
        if (device != null) {
            try {
                int which = Integer.parseInt(device);
                grabber = new OpenCVFrameGrabber(which);
            }
            catch (NumberFormatException ignore) {
                grabber = new OpenCVFrameGrabber(0);
            }
            if (grabber == null) {
                throw new RuntimeException("Can't find webcam with ID or name at " + device);
            }
        } else {
            grabber = new OpenCVFrameGrabber(0);
        }
        grabber.setImageWidth(width);
        grabber.setImageHeight(height);
        return new SimpleSequence<T>(grabber, imageType);
    }

    public static class SimpleSequence<T extends ImageBase<T>>
    implements SimpleImageSequence<T> {
        OpenCVFrameGrabber grabber;
        int width;
        int height;
        T output;
        int frameNumber;
        DogArray_I8 work = new DogArray_I8();
        boolean bgr_to_rgb;

        public SimpleSequence(OpenCVFrameGrabber grabber, ImageType<T> imageType) {
            this.grabber = grabber;
            try {
                this.grabber.start();
            }
            catch (FrameGrabber.Exception e) {
                throw new RuntimeException(e);
            }
            this.bgr_to_rgb = grabber.getPixelFormat() == 1;
            this.width = grabber.getImageWidth();
            this.height = grabber.getImageHeight();
            this.output = imageType.createImage(this.width, this.height);
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public boolean hasNext() {
            try {
                Frame image = this.grabber.grab();
                this.frameNumber = this.grabber.getFrameNumber();
                ConvertOpenCvFrame.convert(image, this.output, this.bgr_to_rgb, this.work);
                return true;
            }
            catch (FrameGrabber.Exception e) {
                return false;
            }
        }

        public T next() {
            return this.output;
        }

        public T getImage() {
            return this.output;
        }

        public <InternalImage> InternalImage getGuiImage() {
            throw new RuntimeException("Implement");
        }

        public void close() {
            try {
                this.grabber.stop();
            }
            catch (FrameGrabber.Exception e) {
                throw new RuntimeException(e);
            }
        }

        public int getFrameNumber() {
            return this.frameNumber;
        }

        public void setLoop(boolean loop) {
        }

        public ImageType<T> getImageType() {
            return this.output.getImageType();
        }

        public void reset() {
        }
    }
}

