/*
 * Decompiled with CFR 0.152.
 */
package boofcv.javacv;

import boofcv.core.image.ConvertByteBufferImage;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.bytedeco.javacv.Frame;
import org.ddogleg.struct.DogArray_I8;

public class ConvertOpenCvFrame {
    public static <T extends ImageGray<T>> void BGR_to_RGB(Planar<T> planar) {
        ImageGray tmp2;
        ImageGray tmp0 = planar.getBand(0);
        planar.bands[0] = tmp2 = planar.getBand(2);
        planar.bands[2] = tmp0;
    }

    public static void convert(Frame input, ImageBase output, boolean swapRgb, DogArray_I8 work) {
        Buffer data;
        if (work == null) {
            work = new DogArray_I8();
        }
        if (!((data = input.image[0]) instanceof ByteBuffer)) {
            return;
        }
        ByteBuffer bb = (ByteBuffer)data;
        output.reshape(input.imageWidth, input.imageHeight);
        if (output instanceof Planar) {
            ((Planar)output).setNumberOfBands(input.imageChannels);
            ConvertByteBufferImage.from_3BU8_to_3PU8((ByteBuffer)bb, (int)0, (int)input.imageStride, (Planar)((Planar)output), (DogArray_I8)work);
            if (swapRgb) {
                ConvertOpenCvFrame.BGR_to_RGB((Planar)output);
            }
        } else if (output instanceof ImageGray) {
            ConvertByteBufferImage.from_3BU8_to_U8((ByteBuffer)bb, (int)0, (int)input.imageStride, (GrayU8)((GrayU8)output), (DogArray_I8)work);
        } else if (output instanceof ImageInterleaved) {
            ConvertByteBufferImage.from_3BU8_to_3IU8((ByteBuffer)bb, (int)0, (int)input.imageStride, (InterleavedU8)((InterleavedU8)output));
        } else {
            throw new IllegalArgumentException("Unsupported output type");
        }
    }
}

