/*
 * Decompiled with CFR 0.152.
 */
package boofcv.javacv;

import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedI8;
import boofcv.struct.image.InterleavedS16;
import boofcv.struct.image.InterleavedS32;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.bytedeco.javacpp.opencv_core;
import org.jetbrains.annotations.Nullable;

public class ConvertIplImage {
    public static <T extends ImageBase<T>> T convertFrom(opencv_core.IplImage input) {
        if (input.nChannels() == 1) {
            return (T)ConvertIplImage.convertFrom(input, null);
        }
        return (T)ConvertIplImage.convertFrom(input, null);
    }

    public static <T extends ImageGray<T>> T convertFrom(opencv_core.IplImage input, @Nullable T output) {
        if (input.nChannels() != 1) {
            throw new IllegalArgumentException("Expected 1 channel for gray scale images");
        }
        ImageDataType dataType = ConvertIplImage.depthToBoofType(input.depth());
        int width = input.width();
        int height = input.height();
        if (output != null) {
            if (output.isSubimage()) {
                throw new IllegalArgumentException("Can't handle sub-images");
            }
            if (output.getDataType() != dataType) {
                throw new IllegalArgumentException("Expected data type of " + dataType + " found " + output.getDataType() + " instead");
            }
            output.reshape(width, height);
        } else {
            output = GeneralizedImageOps.createSingleBand((ImageDataType)dataType, (int)width, (int)height);
        }
        switch (dataType) {
            case U8: 
            case S8: {
                ConvertIplImage.convertFrom_G(input, (GrayI8)output);
                break;
            }
            case S16: {
                ConvertIplImage.convertFrom_G(input, (GrayS16)output);
                break;
            }
            case S32: {
                ConvertIplImage.convertFrom_G(input, (GrayS32)output);
                break;
            }
            case F32: {
                ConvertIplImage.convertFrom_G(input, (GrayF32)output);
                break;
            }
            case F64: {
                ConvertIplImage.convertFrom_G(input, (GrayF64)output);
                break;
            }
            default: {
                throw new RuntimeException("Add support for type " + dataType);
            }
        }
        return output;
    }

    public static <T extends ImageInterleaved<T>> T convertFrom(opencv_core.IplImage input, @Nullable T output) {
        ImageDataType dataType = ConvertIplImage.depthToBoofType(input.depth());
        int numBands = input.nChannels();
        int width = input.width();
        int height = input.height();
        if (output != null) {
            if (output.isSubimage()) {
                throw new IllegalArgumentException("Can't handle sub-images");
            }
            if (output.getDataType() != dataType) {
                throw new IllegalArgumentException("Expected data type of " + dataType + " found " + output.getDataType() + " instead");
            }
            output.numBands = numBands;
            output.reshape(width, height);
        } else {
            output = GeneralizedImageOps.createInterleaved((ImageDataType)dataType, (int)width, (int)height, (int)numBands);
        }
        switch (dataType) {
            case U8: 
            case S8: {
                ConvertIplImage.convertFrom_I(input, (InterleavedI8)output);
                break;
            }
            case S16: {
                ConvertIplImage.convertFrom_I(input, (InterleavedS16)output);
                break;
            }
            case S32: {
                ConvertIplImage.convertFrom_I(input, (InterleavedS32)output);
                break;
            }
            case F32: {
                ConvertIplImage.convertFrom_I(input, (InterleavedF32)output);
                break;
            }
            case F64: {
                ConvertIplImage.convertFrom_I(input, (InterleavedF64)output);
                break;
            }
            default: {
                throw new RuntimeException("Add support for type " + dataType);
            }
        }
        return output;
    }

    private static void convertFrom_G(opencv_core.IplImage input, GrayI8 output) {
        ByteBuffer buffer = (ByteBuffer)input.createBuffer();
        int width = input.width();
        int height = input.height();
        int stride = input.widthStep();
        for (int y = 0; y < height; ++y) {
            buffer.position(y * stride);
            buffer.get(output.data, y * output.stride, width);
        }
    }

    private static void convertFrom_I(opencv_core.IplImage input, InterleavedI8 output) {
        ByteBuffer buffer = (ByteBuffer)input.createBuffer();
        int height = input.height();
        int stride = input.widthStep();
        int dataWidth = input.width() * input.nChannels();
        for (int y = 0; y < height; ++y) {
            buffer.position(y * stride);
            buffer.get(output.data, y * output.stride, dataWidth);
        }
    }

    private static void convertFrom_G(opencv_core.IplImage input, GrayS16 output) {
        ShortBuffer buffer = (ShortBuffer)input.createBuffer();
        int width = input.width();
        int height = input.height();
        int stride = input.widthStep() / 2;
        for (int y = 0; y < height; ++y) {
            buffer.position(y * stride);
            buffer.get(output.data, y * output.stride, width);
        }
    }

    private static void convertFrom_I(opencv_core.IplImage input, InterleavedS16 output) {
        ShortBuffer buffer = (ShortBuffer)input.createBuffer();
        int height = input.height();
        int stride = input.widthStep() / 2;
        int dataWidth = input.width() * input.nChannels();
        for (int y = 0; y < height; ++y) {
            buffer.position(y * stride);
            buffer.get(output.data, y * output.stride, dataWidth);
        }
    }

    private static void convertFrom_G(opencv_core.IplImage input, GrayS32 output) {
        IntBuffer buffer = (IntBuffer)input.createBuffer();
        int width = input.width();
        int height = input.height();
        int stride = input.widthStep() / 4;
        for (int y = 0; y < height; ++y) {
            buffer.position(y * stride);
            buffer.get(output.data, y * output.stride, width);
        }
    }

    private static void convertFrom_I(opencv_core.IplImage input, InterleavedS32 output) {
        IntBuffer buffer = (IntBuffer)input.createBuffer();
        int height = input.height();
        int stride = input.widthStep() / 4;
        int dataWidth = input.width() * input.nChannels();
        for (int y = 0; y < height; ++y) {
            buffer.position(y * stride);
            buffer.get(output.data, y * output.stride, dataWidth);
        }
    }

    private static void convertFrom_G(opencv_core.IplImage input, GrayF32 output) {
        FloatBuffer buffer = (FloatBuffer)input.createBuffer();
        int width = input.width();
        int height = input.height();
        int stride = input.widthStep() / 4;
        for (int y = 0; y < height; ++y) {
            buffer.position(y * stride);
            buffer.get(output.data, y * output.stride, width);
        }
    }

    private static void convertFrom_I(opencv_core.IplImage input, InterleavedF32 output) {
        FloatBuffer buffer = (FloatBuffer)input.createBuffer();
        int height = input.height();
        int stride = input.widthStep() / 4;
        int dataWidth = input.width() * input.nChannels();
        for (int y = 0; y < height; ++y) {
            buffer.position(y * stride);
            buffer.get(output.data, y * output.stride, dataWidth);
        }
    }

    private static void convertFrom_G(opencv_core.IplImage input, GrayF64 output) {
        DoubleBuffer buffer = (DoubleBuffer)input.createBuffer();
        int width = input.width();
        int height = input.height();
        int stride = input.widthStep() / 8;
        for (int y = 0; y < height; ++y) {
            buffer.position(y * stride);
            buffer.get(output.data, y * output.stride, width);
        }
    }

    private static void convertFrom_I(opencv_core.IplImage input, InterleavedF64 output) {
        DoubleBuffer buffer = (DoubleBuffer)input.createBuffer();
        int height = input.height();
        int stride = input.widthStep() / 8;
        int dataWidth = input.width() * input.nChannels();
        for (int y = 0; y < height; ++y) {
            buffer.position(y * stride);
            buffer.get(output.data, y * output.stride, dataWidth);
        }
    }

    public static ImageDataType depthToBoofType(int depth) {
        switch (depth) {
            case 8: {
                return ImageDataType.U8;
            }
            case -2147483640: {
                return ImageDataType.S8;
            }
            case -2147483632: {
                return ImageDataType.S16;
            }
            case -2147483616: {
                return ImageDataType.S32;
            }
            case 32: {
                return ImageDataType.F32;
            }
            case 64: {
                return ImageDataType.F64;
            }
        }
        throw new IllegalArgumentException("Unknown IPL depth " + depth);
    }
}

