/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.image;

import boofcv.concurrency.BoofConcurrency;
import boofcv.core.image.impl.ConvertInterleavedToSingle;
import boofcv.core.image.impl.ConvertInterleavedToSingle_MT;
import boofcv.core.image.impl.ImplConvertImage;
import boofcv.core.image.impl.ImplConvertImage_MT;
import boofcv.core.image.impl.ImplConvertPlanarToGray;
import boofcv.core.image.impl.ImplConvertPlanarToGray_MT;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedI16;
import boofcv.struct.image.InterleavedI8;
import boofcv.struct.image.InterleavedS16;
import boofcv.struct.image.InterleavedS32;
import boofcv.struct.image.InterleavedS64;
import boofcv.struct.image.InterleavedS8;
import boofcv.struct.image.InterleavedU16;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;

public class ConvertImage {
    public static GrayS8 convert(GrayU8 input, GrayS8 output) {
        if (output == null) {
            output = new GrayS8(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (GrayI8)output);
        return output;
    }

    public static InterleavedS8 convert(InterleavedU8 input, InterleavedS8 output) {
        if (output == null) {
            output = new InterleavedS8(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (InterleavedI8)output);
        return output;
    }

    public static GrayU16 convert(GrayU8 input, GrayU16 output) {
        if (output == null) {
            output = new GrayU16(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (GrayI16)output);
        return output;
    }

    public static InterleavedU16 convert(InterleavedU8 input, InterleavedU16 output) {
        if (output == null) {
            output = new InterleavedU16(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (InterleavedI16)output);
        return output;
    }

    public static GrayS16 convert(GrayU8 input, GrayS16 output) {
        if (output == null) {
            output = new GrayS16(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (GrayI16)output);
        return output;
    }

    public static InterleavedS16 convert(InterleavedU8 input, InterleavedS16 output) {
        if (output == null) {
            output = new InterleavedS16(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (InterleavedI16)output);
        return output;
    }

    public static GrayS32 convert(GrayU8 input, GrayS32 output) {
        if (output == null) {
            output = new GrayS32(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static InterleavedS32 convert(InterleavedU8 input, InterleavedS32 output) {
        if (output == null) {
            output = new InterleavedS32(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static GrayS64 convert(GrayU8 input, GrayS64 output) {
        if (output == null) {
            output = new GrayS64(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static InterleavedS64 convert(InterleavedU8 input, InterleavedS64 output) {
        if (output == null) {
            output = new InterleavedS64(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static GrayF32 convert(GrayU8 input, GrayF32 output) {
        if (output == null) {
            output = new GrayF32(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static InterleavedF32 convert(InterleavedU8 input, InterleavedF32 output) {
        if (output == null) {
            output = new InterleavedF32(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static GrayF64 convert(GrayU8 input, GrayF64 output) {
        if (output == null) {
            output = new GrayF64(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static InterleavedF64 convert(InterleavedU8 input, InterleavedF64 output) {
        if (output == null) {
            output = new InterleavedF64(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static GrayU8 average(Planar<GrayU8> input, GrayU8 output) {
        if (output == null) {
            output = new GrayU8(input.width, input.height);
        } else {
            output.reshapeTo(input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertPlanarToGray_MT.average(input, output);
        } else {
            ImplConvertPlanarToGray.average(input, output);
        }
        return output;
    }

    public static InterleavedU8 convert(Planar<GrayU8> input, InterleavedU8 output) {
        if (output == null) {
            output = new InterleavedU8(input.width, input.height, input.getNumBands());
        } else {
            output.reshapeTo(input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertImage_MT.convert(input, output);
        } else {
            ImplConvertImage.convert(input, output);
        }
        return output;
    }

    public static GrayU8 average(InterleavedU8 input, GrayU8 output) {
        if (output == null) {
            output = new GrayU8(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ConvertInterleavedToSingle_MT.average(input, output);
        } else {
            ConvertInterleavedToSingle.average(input, output);
        }
        return output;
    }

    public static Planar<GrayU8> convert(InterleavedU8 input, Planar<GrayU8> output) {
        if (output == null) {
            output = new Planar(GrayU8.class, input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertImage_MT.convert(input, output);
        } else {
            ImplConvertImage.convert(input, output);
        }
        return output;
    }

    public static GrayU8 convert(GrayU8 input, int min, int max, int numValues, GrayU8 output) {
        if (output == null) {
            output = new GrayU8(input.width, input.height);
        } else {
            output.reshape(input.width, input.height);
        }
        if (numValues < 0 || numValues > 256) {
            throw new IllegalArgumentException("0 <= numValues <= 256");
        }
        --numValues;
        int range = max - min;
        for (int y = 0; y < input.height; ++y) {
            int indexIn = input.startIndex + y * input.stride;
            int indexOut = output.startIndex + y * output.stride;
            for (int x = 0; x < input.width; ++x) {
                int value = numValues * ((input.data[indexIn++] & 0xFF) - min) / range;
                output.data[indexOut++] = (byte)value;
            }
        }
        return output;
    }

    public static GrayU8 convert(GrayS8 input, GrayU8 output) {
        if (output == null) {
            output = new GrayU8(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (GrayI8)output);
        return output;
    }

    public static InterleavedU8 convert(InterleavedS8 input, InterleavedU8 output) {
        if (output == null) {
            output = new InterleavedU8(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (InterleavedI8)output);
        return output;
    }

    public static GrayU16 convert(GrayS8 input, GrayU16 output) {
        if (output == null) {
            output = new GrayU16(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (GrayI16)output);
        return output;
    }

    public static InterleavedU16 convert(InterleavedS8 input, InterleavedU16 output) {
        if (output == null) {
            output = new InterleavedU16(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (InterleavedI16)output);
        return output;
    }

    public static GrayS16 convert(GrayS8 input, GrayS16 output) {
        if (output == null) {
            output = new GrayS16(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (GrayI16)output);
        return output;
    }

    public static InterleavedS16 convert(InterleavedS8 input, InterleavedS16 output) {
        if (output == null) {
            output = new InterleavedS16(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (InterleavedI16)output);
        return output;
    }

    public static GrayS32 convert(GrayS8 input, GrayS32 output) {
        if (output == null) {
            output = new GrayS32(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static InterleavedS32 convert(InterleavedS8 input, InterleavedS32 output) {
        if (output == null) {
            output = new InterleavedS32(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static GrayS64 convert(GrayS8 input, GrayS64 output) {
        if (output == null) {
            output = new GrayS64(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static InterleavedS64 convert(InterleavedS8 input, InterleavedS64 output) {
        if (output == null) {
            output = new InterleavedS64(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static GrayF32 convert(GrayS8 input, GrayF32 output) {
        if (output == null) {
            output = new GrayF32(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static InterleavedF32 convert(InterleavedS8 input, InterleavedF32 output) {
        if (output == null) {
            output = new InterleavedF32(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static GrayF64 convert(GrayS8 input, GrayF64 output) {
        if (output == null) {
            output = new GrayF64(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static InterleavedF64 convert(InterleavedS8 input, InterleavedF64 output) {
        if (output == null) {
            output = new InterleavedF64(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static GrayS8 average(Planar<GrayS8> input, GrayS8 output) {
        if (output == null) {
            output = new GrayS8(input.width, input.height);
        } else {
            output.reshapeTo(input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertPlanarToGray_MT.average(input, output);
        } else {
            ImplConvertPlanarToGray.average(input, output);
        }
        return output;
    }

    public static InterleavedS8 convert(Planar<GrayS8> input, InterleavedS8 output) {
        if (output == null) {
            output = new InterleavedS8(input.width, input.height, input.getNumBands());
        } else {
            output.reshapeTo(input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertImage_MT.convert(input, output);
        } else {
            ImplConvertImage.convert(input, output);
        }
        return output;
    }

    public static GrayS8 average(InterleavedS8 input, GrayS8 output) {
        if (output == null) {
            output = new GrayS8(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ConvertInterleavedToSingle_MT.average(input, output);
        } else {
            ConvertInterleavedToSingle.average(input, output);
        }
        return output;
    }

    public static Planar<GrayS8> convert(InterleavedS8 input, Planar<GrayS8> output) {
        if (output == null) {
            output = new Planar(GrayS8.class, input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertImage_MT.convert(input, output);
        } else {
            ImplConvertImage.convert(input, output);
        }
        return output;
    }

    public static GrayU8 convert(GrayS8 input, int min, int max, int numValues, GrayU8 output) {
        if (output == null) {
            output = new GrayU8(input.width, input.height);
        } else {
            output.reshape(input.width, input.height);
        }
        if (numValues < 0 || numValues > 256) {
            throw new IllegalArgumentException("0 <= numValues <= 256");
        }
        --numValues;
        int range = max - min;
        for (int y = 0; y < input.height; ++y) {
            int indexIn = input.startIndex + y * input.stride;
            int indexOut = output.startIndex + y * output.stride;
            for (int x = 0; x < input.width; ++x) {
                int value = numValues * (input.data[indexIn++] - min) / range;
                output.data[indexOut++] = (byte)value;
            }
        }
        return output;
    }

    public static GrayU8 convert(GrayU16 input, GrayU8 output) {
        if (output == null) {
            output = new GrayU8(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (GrayI8)output);
        return output;
    }

    public static InterleavedU8 convert(InterleavedU16 input, InterleavedU8 output) {
        if (output == null) {
            output = new InterleavedU8(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (InterleavedI8)output);
        return output;
    }

    public static GrayS8 convert(GrayU16 input, GrayS8 output) {
        if (output == null) {
            output = new GrayS8(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (GrayI8)output);
        return output;
    }

    public static InterleavedS8 convert(InterleavedU16 input, InterleavedS8 output) {
        if (output == null) {
            output = new InterleavedS8(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (InterleavedI8)output);
        return output;
    }

    public static GrayS16 convert(GrayU16 input, GrayS16 output) {
        if (output == null) {
            output = new GrayS16(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (GrayI16)output);
        return output;
    }

    public static InterleavedS16 convert(InterleavedU16 input, InterleavedS16 output) {
        if (output == null) {
            output = new InterleavedS16(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (InterleavedI16)output);
        return output;
    }

    public static GrayS32 convert(GrayU16 input, GrayS32 output) {
        if (output == null) {
            output = new GrayS32(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static InterleavedS32 convert(InterleavedU16 input, InterleavedS32 output) {
        if (output == null) {
            output = new InterleavedS32(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static GrayS64 convert(GrayU16 input, GrayS64 output) {
        if (output == null) {
            output = new GrayS64(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static InterleavedS64 convert(InterleavedU16 input, InterleavedS64 output) {
        if (output == null) {
            output = new InterleavedS64(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static GrayF32 convert(GrayU16 input, GrayF32 output) {
        if (output == null) {
            output = new GrayF32(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static InterleavedF32 convert(InterleavedU16 input, InterleavedF32 output) {
        if (output == null) {
            output = new InterleavedF32(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static GrayF64 convert(GrayU16 input, GrayF64 output) {
        if (output == null) {
            output = new GrayF64(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static InterleavedF64 convert(InterleavedU16 input, InterleavedF64 output) {
        if (output == null) {
            output = new InterleavedF64(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static GrayU16 average(Planar<GrayU16> input, GrayU16 output) {
        if (output == null) {
            output = new GrayU16(input.width, input.height);
        } else {
            output.reshapeTo(input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertPlanarToGray_MT.average(input, output);
        } else {
            ImplConvertPlanarToGray.average(input, output);
        }
        return output;
    }

    public static InterleavedU16 convert(Planar<GrayU16> input, InterleavedU16 output) {
        if (output == null) {
            output = new InterleavedU16(input.width, input.height, input.getNumBands());
        } else {
            output.reshapeTo(input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertImage_MT.convert(input, output);
        } else {
            ImplConvertImage.convert(input, output);
        }
        return output;
    }

    public static GrayU16 average(InterleavedU16 input, GrayU16 output) {
        if (output == null) {
            output = new GrayU16(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ConvertInterleavedToSingle_MT.average(input, output);
        } else {
            ConvertInterleavedToSingle.average(input, output);
        }
        return output;
    }

    public static Planar<GrayU16> convert(InterleavedU16 input, Planar<GrayU16> output) {
        if (output == null) {
            output = new Planar(GrayU16.class, input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertImage_MT.convert(input, output);
        } else {
            ImplConvertImage.convert(input, output);
        }
        return output;
    }

    public static GrayU8 convert(GrayU16 input, int min, int max, int numValues, GrayU8 output) {
        if (output == null) {
            output = new GrayU8(input.width, input.height);
        } else {
            output.reshape(input.width, input.height);
        }
        if (numValues < 0 || numValues > 256) {
            throw new IllegalArgumentException("0 <= numValues <= 256");
        }
        --numValues;
        int range = max - min;
        for (int y = 0; y < input.height; ++y) {
            int indexIn = input.startIndex + y * input.stride;
            int indexOut = output.startIndex + y * output.stride;
            for (int x = 0; x < input.width; ++x) {
                int value = numValues * ((input.data[indexIn++] & 0xFFFF) - min) / range;
                output.data[indexOut++] = (byte)value;
            }
        }
        return output;
    }

    public static GrayU8 convert(GrayS16 input, GrayU8 output) {
        if (output == null) {
            output = new GrayU8(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (GrayI8)output);
        return output;
    }

    public static InterleavedU8 convert(InterleavedS16 input, InterleavedU8 output) {
        if (output == null) {
            output = new InterleavedU8(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (InterleavedI8)output);
        return output;
    }

    public static GrayS8 convert(GrayS16 input, GrayS8 output) {
        if (output == null) {
            output = new GrayS8(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (GrayI8)output);
        return output;
    }

    public static InterleavedS8 convert(InterleavedS16 input, InterleavedS8 output) {
        if (output == null) {
            output = new InterleavedS8(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (InterleavedI8)output);
        return output;
    }

    public static GrayU16 convert(GrayS16 input, GrayU16 output) {
        if (output == null) {
            output = new GrayU16(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (GrayI16)output);
        return output;
    }

    public static InterleavedU16 convert(InterleavedS16 input, InterleavedU16 output) {
        if (output == null) {
            output = new InterleavedU16(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (InterleavedI16)output);
        return output;
    }

    public static GrayS32 convert(GrayS16 input, GrayS32 output) {
        if (output == null) {
            output = new GrayS32(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static InterleavedS32 convert(InterleavedS16 input, InterleavedS32 output) {
        if (output == null) {
            output = new InterleavedS32(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static GrayS64 convert(GrayS16 input, GrayS64 output) {
        if (output == null) {
            output = new GrayS64(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static InterleavedS64 convert(InterleavedS16 input, InterleavedS64 output) {
        if (output == null) {
            output = new InterleavedS64(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static GrayF32 convert(GrayS16 input, GrayF32 output) {
        if (output == null) {
            output = new GrayF32(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static InterleavedF32 convert(InterleavedS16 input, InterleavedF32 output) {
        if (output == null) {
            output = new InterleavedF32(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static GrayF64 convert(GrayS16 input, GrayF64 output) {
        if (output == null) {
            output = new GrayF64(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static InterleavedF64 convert(InterleavedS16 input, InterleavedF64 output) {
        if (output == null) {
            output = new InterleavedF64(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static GrayS16 average(Planar<GrayS16> input, GrayS16 output) {
        if (output == null) {
            output = new GrayS16(input.width, input.height);
        } else {
            output.reshapeTo(input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertPlanarToGray_MT.average(input, output);
        } else {
            ImplConvertPlanarToGray.average(input, output);
        }
        return output;
    }

    public static InterleavedS16 convert(Planar<GrayS16> input, InterleavedS16 output) {
        if (output == null) {
            output = new InterleavedS16(input.width, input.height, input.getNumBands());
        } else {
            output.reshapeTo(input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertImage_MT.convert(input, output);
        } else {
            ImplConvertImage.convert(input, output);
        }
        return output;
    }

    public static GrayS16 average(InterleavedS16 input, GrayS16 output) {
        if (output == null) {
            output = new GrayS16(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ConvertInterleavedToSingle_MT.average(input, output);
        } else {
            ConvertInterleavedToSingle.average(input, output);
        }
        return output;
    }

    public static Planar<GrayS16> convert(InterleavedS16 input, Planar<GrayS16> output) {
        if (output == null) {
            output = new Planar(GrayS16.class, input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertImage_MT.convert(input, output);
        } else {
            ImplConvertImage.convert(input, output);
        }
        return output;
    }

    public static GrayU8 convert(GrayS16 input, int min, int max, int numValues, GrayU8 output) {
        if (output == null) {
            output = new GrayU8(input.width, input.height);
        } else {
            output.reshape(input.width, input.height);
        }
        if (numValues < 0 || numValues > 256) {
            throw new IllegalArgumentException("0 <= numValues <= 256");
        }
        --numValues;
        int range = max - min;
        for (int y = 0; y < input.height; ++y) {
            int indexIn = input.startIndex + y * input.stride;
            int indexOut = output.startIndex + y * output.stride;
            for (int x = 0; x < input.width; ++x) {
                int value = numValues * (input.data[indexIn++] - min) / range;
                output.data[indexOut++] = (byte)value;
            }
        }
        return output;
    }

    public static GrayU8 convert(GrayS32 input, GrayU8 output) {
        if (output == null) {
            output = new GrayU8(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (GrayI8)output);
        return output;
    }

    public static InterleavedU8 convert(InterleavedS32 input, InterleavedU8 output) {
        if (output == null) {
            output = new InterleavedU8(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (InterleavedI8)output);
        return output;
    }

    public static GrayS8 convert(GrayS32 input, GrayS8 output) {
        if (output == null) {
            output = new GrayS8(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (GrayI8)output);
        return output;
    }

    public static InterleavedS8 convert(InterleavedS32 input, InterleavedS8 output) {
        if (output == null) {
            output = new InterleavedS8(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (InterleavedI8)output);
        return output;
    }

    public static GrayU16 convert(GrayS32 input, GrayU16 output) {
        if (output == null) {
            output = new GrayU16(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (GrayI16)output);
        return output;
    }

    public static InterleavedU16 convert(InterleavedS32 input, InterleavedU16 output) {
        if (output == null) {
            output = new InterleavedU16(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (InterleavedI16)output);
        return output;
    }

    public static GrayS16 convert(GrayS32 input, GrayS16 output) {
        if (output == null) {
            output = new GrayS16(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (GrayI16)output);
        return output;
    }

    public static InterleavedS16 convert(InterleavedS32 input, InterleavedS16 output) {
        if (output == null) {
            output = new InterleavedS16(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (InterleavedI16)output);
        return output;
    }

    public static GrayS64 convert(GrayS32 input, GrayS64 output) {
        if (output == null) {
            output = new GrayS64(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static InterleavedS64 convert(InterleavedS32 input, InterleavedS64 output) {
        if (output == null) {
            output = new InterleavedS64(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static GrayF32 convert(GrayS32 input, GrayF32 output) {
        if (output == null) {
            output = new GrayF32(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static InterleavedF32 convert(InterleavedS32 input, InterleavedF32 output) {
        if (output == null) {
            output = new InterleavedF32(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static GrayF64 convert(GrayS32 input, GrayF64 output) {
        if (output == null) {
            output = new GrayF64(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static InterleavedF64 convert(InterleavedS32 input, InterleavedF64 output) {
        if (output == null) {
            output = new InterleavedF64(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static GrayS32 average(Planar<GrayS32> input, GrayS32 output) {
        if (output == null) {
            output = new GrayS32(input.width, input.height);
        } else {
            output.reshapeTo(input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertPlanarToGray_MT.average(input, output);
        } else {
            ImplConvertPlanarToGray.average(input, output);
        }
        return output;
    }

    public static InterleavedS32 convert(Planar<GrayS32> input, InterleavedS32 output) {
        if (output == null) {
            output = new InterleavedS32(input.width, input.height, input.getNumBands());
        } else {
            output.reshapeTo(input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertImage_MT.convert(input, output);
        } else {
            ImplConvertImage.convert(input, output);
        }
        return output;
    }

    public static GrayS32 average(InterleavedS32 input, GrayS32 output) {
        if (output == null) {
            output = new GrayS32(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ConvertInterleavedToSingle_MT.average(input, output);
        } else {
            ConvertInterleavedToSingle.average(input, output);
        }
        return output;
    }

    public static Planar<GrayS32> convert(InterleavedS32 input, Planar<GrayS32> output) {
        if (output == null) {
            output = new Planar(GrayS32.class, input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertImage_MT.convert(input, output);
        } else {
            ImplConvertImage.convert(input, output);
        }
        return output;
    }

    public static GrayU8 convert(GrayS32 input, int min, int max, int numValues, GrayU8 output) {
        if (output == null) {
            output = new GrayU8(input.width, input.height);
        } else {
            output.reshape(input.width, input.height);
        }
        if (numValues < 0 || numValues > 256) {
            throw new IllegalArgumentException("0 <= numValues <= 256");
        }
        --numValues;
        int range = max - min;
        for (int y = 0; y < input.height; ++y) {
            int indexIn = input.startIndex + y * input.stride;
            int indexOut = output.startIndex + y * output.stride;
            for (int x = 0; x < input.width; ++x) {
                int value = numValues * (input.data[indexIn++] - min) / range;
                output.data[indexOut++] = (byte)value;
            }
        }
        return output;
    }

    public static GrayU8 convert(GrayS64 input, GrayU8 output) {
        if (output == null) {
            output = new GrayU8(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (GrayI8)output);
        return output;
    }

    public static InterleavedU8 convert(InterleavedS64 input, InterleavedU8 output) {
        if (output == null) {
            output = new InterleavedU8(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (InterleavedI8)output);
        return output;
    }

    public static GrayS8 convert(GrayS64 input, GrayS8 output) {
        if (output == null) {
            output = new GrayS8(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (GrayI8)output);
        return output;
    }

    public static InterleavedS8 convert(InterleavedS64 input, InterleavedS8 output) {
        if (output == null) {
            output = new InterleavedS8(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (InterleavedI8)output);
        return output;
    }

    public static GrayU16 convert(GrayS64 input, GrayU16 output) {
        if (output == null) {
            output = new GrayU16(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (GrayI16)output);
        return output;
    }

    public static InterleavedU16 convert(InterleavedS64 input, InterleavedU16 output) {
        if (output == null) {
            output = new InterleavedU16(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (InterleavedI16)output);
        return output;
    }

    public static GrayS16 convert(GrayS64 input, GrayS16 output) {
        if (output == null) {
            output = new GrayS16(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (GrayI16)output);
        return output;
    }

    public static InterleavedS16 convert(InterleavedS64 input, InterleavedS16 output) {
        if (output == null) {
            output = new InterleavedS16(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (InterleavedI16)output);
        return output;
    }

    public static GrayS32 convert(GrayS64 input, GrayS32 output) {
        if (output == null) {
            output = new GrayS32(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static InterleavedS32 convert(InterleavedS64 input, InterleavedS32 output) {
        if (output == null) {
            output = new InterleavedS32(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static GrayF32 convert(GrayS64 input, GrayF32 output) {
        if (output == null) {
            output = new GrayF32(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static InterleavedF32 convert(InterleavedS64 input, InterleavedF32 output) {
        if (output == null) {
            output = new InterleavedF32(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static GrayF64 convert(GrayS64 input, GrayF64 output) {
        if (output == null) {
            output = new GrayF64(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static InterleavedF64 convert(InterleavedS64 input, InterleavedF64 output) {
        if (output == null) {
            output = new InterleavedF64(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static GrayS64 average(Planar<GrayS64> input, GrayS64 output) {
        if (output == null) {
            output = new GrayS64(input.width, input.height);
        } else {
            output.reshapeTo(input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertPlanarToGray_MT.average(input, output);
        } else {
            ImplConvertPlanarToGray.average(input, output);
        }
        return output;
    }

    public static InterleavedS64 convert(Planar<GrayS64> input, InterleavedS64 output) {
        if (output == null) {
            output = new InterleavedS64(input.width, input.height, input.getNumBands());
        } else {
            output.reshapeTo(input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertImage_MT.convert(input, output);
        } else {
            ImplConvertImage.convert(input, output);
        }
        return output;
    }

    public static GrayS64 average(InterleavedS64 input, GrayS64 output) {
        if (output == null) {
            output = new GrayS64(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ConvertInterleavedToSingle_MT.average(input, output);
        } else {
            ConvertInterleavedToSingle.average(input, output);
        }
        return output;
    }

    public static Planar<GrayS64> convert(InterleavedS64 input, Planar<GrayS64> output) {
        if (output == null) {
            output = new Planar(GrayS64.class, input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertImage_MT.convert(input, output);
        } else {
            ImplConvertImage.convert(input, output);
        }
        return output;
    }

    public static GrayU8 convert(GrayS64 input, long min, long max, int numValues, GrayU8 output) {
        if (output == null) {
            output = new GrayU8(input.width, input.height);
        } else {
            output.reshape(input.width, input.height);
        }
        if (numValues < 0 || numValues > 256) {
            throw new IllegalArgumentException("0 <= numValues <= 256");
        }
        --numValues;
        long range = max - min;
        for (int y = 0; y < input.height; ++y) {
            int indexIn = input.startIndex + y * input.stride;
            int indexOut = output.startIndex + y * output.stride;
            for (int x = 0; x < input.width; ++x) {
                int value = (int)((long)numValues * (input.data[indexIn++] - min) / range);
                output.data[indexOut++] = (byte)value;
            }
        }
        return output;
    }

    public static GrayU8 convert(GrayF32 input, GrayU8 output) {
        if (output == null) {
            output = new GrayU8(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (GrayI8)output);
        return output;
    }

    public static InterleavedU8 convert(InterleavedF32 input, InterleavedU8 output) {
        if (output == null) {
            output = new InterleavedU8(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (InterleavedI8)output);
        return output;
    }

    public static GrayS8 convert(GrayF32 input, GrayS8 output) {
        if (output == null) {
            output = new GrayS8(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (GrayI8)output);
        return output;
    }

    public static InterleavedS8 convert(InterleavedF32 input, InterleavedS8 output) {
        if (output == null) {
            output = new InterleavedS8(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (InterleavedI8)output);
        return output;
    }

    public static GrayU16 convert(GrayF32 input, GrayU16 output) {
        if (output == null) {
            output = new GrayU16(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (GrayI16)output);
        return output;
    }

    public static InterleavedU16 convert(InterleavedF32 input, InterleavedU16 output) {
        if (output == null) {
            output = new InterleavedU16(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (InterleavedI16)output);
        return output;
    }

    public static GrayS16 convert(GrayF32 input, GrayS16 output) {
        if (output == null) {
            output = new GrayS16(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (GrayI16)output);
        return output;
    }

    public static InterleavedS16 convert(InterleavedF32 input, InterleavedS16 output) {
        if (output == null) {
            output = new InterleavedS16(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (InterleavedI16)output);
        return output;
    }

    public static GrayS32 convert(GrayF32 input, GrayS32 output) {
        if (output == null) {
            output = new GrayS32(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static InterleavedS32 convert(InterleavedF32 input, InterleavedS32 output) {
        if (output == null) {
            output = new InterleavedS32(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static GrayS64 convert(GrayF32 input, GrayS64 output) {
        if (output == null) {
            output = new GrayS64(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static InterleavedS64 convert(InterleavedF32 input, InterleavedS64 output) {
        if (output == null) {
            output = new InterleavedS64(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static GrayF64 convert(GrayF32 input, GrayF64 output) {
        if (output == null) {
            output = new GrayF64(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static InterleavedF64 convert(InterleavedF32 input, InterleavedF64 output) {
        if (output == null) {
            output = new InterleavedF64(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static GrayF32 average(Planar<GrayF32> input, GrayF32 output) {
        if (output == null) {
            output = new GrayF32(input.width, input.height);
        } else {
            output.reshapeTo(input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertPlanarToGray_MT.average(input, output);
        } else {
            ImplConvertPlanarToGray.average(input, output);
        }
        return output;
    }

    public static InterleavedF32 convert(Planar<GrayF32> input, InterleavedF32 output) {
        if (output == null) {
            output = new InterleavedF32(input.width, input.height, input.getNumBands());
        } else {
            output.reshapeTo(input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertImage_MT.convert(input, output);
        } else {
            ImplConvertImage.convert(input, output);
        }
        return output;
    }

    public static GrayF32 average(InterleavedF32 input, GrayF32 output) {
        if (output == null) {
            output = new GrayF32(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ConvertInterleavedToSingle_MT.average(input, output);
        } else {
            ConvertInterleavedToSingle.average(input, output);
        }
        return output;
    }

    public static Planar<GrayF32> convert(InterleavedF32 input, Planar<GrayF32> output) {
        if (output == null) {
            output = new Planar(GrayF32.class, input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertImage_MT.convert(input, output);
        } else {
            ImplConvertImage.convert(input, output);
        }
        return output;
    }

    public static GrayU8 convert(GrayF32 input, float min, float max, int numValues, GrayU8 output) {
        if (output == null) {
            output = new GrayU8(input.width, input.height);
        } else {
            output.reshape(input.width, input.height);
        }
        if (numValues < 0 || numValues > 256) {
            throw new IllegalArgumentException("0 <= numValues <= 256");
        }
        --numValues;
        float range = max - min;
        for (int y = 0; y < input.height; ++y) {
            int indexIn = input.startIndex + y * input.stride;
            int indexOut = output.startIndex + y * output.stride;
            for (int x = 0; x < input.width; ++x) {
                int value = (int)((float)numValues * (input.data[indexIn++] - min) / range + 0.5f);
                output.data[indexOut++] = (byte)value;
            }
        }
        return output;
    }

    public static GrayU8 convert(GrayF64 input, GrayU8 output) {
        if (output == null) {
            output = new GrayU8(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (GrayI8)output);
        return output;
    }

    public static InterleavedU8 convert(InterleavedF64 input, InterleavedU8 output) {
        if (output == null) {
            output = new InterleavedU8(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (InterleavedI8)output);
        return output;
    }

    public static GrayS8 convert(GrayF64 input, GrayS8 output) {
        if (output == null) {
            output = new GrayS8(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (GrayI8)output);
        return output;
    }

    public static InterleavedS8 convert(InterleavedF64 input, InterleavedS8 output) {
        if (output == null) {
            output = new InterleavedS8(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (InterleavedI8)output);
        return output;
    }

    public static GrayU16 convert(GrayF64 input, GrayU16 output) {
        if (output == null) {
            output = new GrayU16(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (GrayI16)output);
        return output;
    }

    public static InterleavedU16 convert(InterleavedF64 input, InterleavedU16 output) {
        if (output == null) {
            output = new InterleavedU16(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (InterleavedI16)output);
        return output;
    }

    public static GrayS16 convert(GrayF64 input, GrayS16 output) {
        if (output == null) {
            output = new GrayS16(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (GrayI16)output);
        return output;
    }

    public static InterleavedS16 convert(InterleavedF64 input, InterleavedS16 output) {
        if (output == null) {
            output = new InterleavedS16(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, (InterleavedI16)output);
        return output;
    }

    public static GrayS32 convert(GrayF64 input, GrayS32 output) {
        if (output == null) {
            output = new GrayS32(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static InterleavedS32 convert(InterleavedF64 input, InterleavedS32 output) {
        if (output == null) {
            output = new InterleavedS32(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static GrayS64 convert(GrayF64 input, GrayS64 output) {
        if (output == null) {
            output = new GrayS64(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static InterleavedS64 convert(InterleavedF64 input, InterleavedS64 output) {
        if (output == null) {
            output = new InterleavedS64(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static GrayF32 convert(GrayF64 input, GrayF32 output) {
        if (output == null) {
            output = new GrayF32(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static InterleavedF32 convert(InterleavedF64 input, InterleavedF32 output) {
        if (output == null) {
            output = new InterleavedF32(input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        ImplConvertImage.convert(input, output);
        return output;
    }

    public static GrayF64 average(Planar<GrayF64> input, GrayF64 output) {
        if (output == null) {
            output = new GrayF64(input.width, input.height);
        } else {
            output.reshapeTo(input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertPlanarToGray_MT.average(input, output);
        } else {
            ImplConvertPlanarToGray.average(input, output);
        }
        return output;
    }

    public static InterleavedF64 convert(Planar<GrayF64> input, InterleavedF64 output) {
        if (output == null) {
            output = new InterleavedF64(input.width, input.height, input.getNumBands());
        } else {
            output.reshapeTo(input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertImage_MT.convert(input, output);
        } else {
            ImplConvertImage.convert(input, output);
        }
        return output;
    }

    public static GrayF64 average(InterleavedF64 input, GrayF64 output) {
        if (output == null) {
            output = new GrayF64(input.width, input.height);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ConvertInterleavedToSingle_MT.average(input, output);
        } else {
            ConvertInterleavedToSingle.average(input, output);
        }
        return output;
    }

    public static Planar<GrayF64> convert(InterleavedF64 input, Planar<GrayF64> output) {
        if (output == null) {
            output = new Planar(GrayF64.class, input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertImage_MT.convert(input, output);
        } else {
            ImplConvertImage.convert(input, output);
        }
        return output;
    }

    public static GrayU8 convert(GrayF64 input, double min, double max, int numValues, GrayU8 output) {
        if (output == null) {
            output = new GrayU8(input.width, input.height);
        } else {
            output.reshape(input.width, input.height);
        }
        if (numValues < 0 || numValues > 256) {
            throw new IllegalArgumentException("0 <= numValues <= 256");
        }
        --numValues;
        double range = max - min;
        for (int y = 0; y < input.height; ++y) {
            int indexIn = input.startIndex + y * input.stride;
            int indexOut = output.startIndex + y * output.stride;
            for (int x = 0; x < input.width; ++x) {
                int value = (int)((double)numValues * (input.data[indexIn++] - min) / range + 0.5);
                output.data[indexOut++] = (byte)value;
            }
        }
        return output;
    }

    public static Planar<GrayF32> convertU8F32(InterleavedU8 input, Planar<GrayF32> output) {
        if (output == null) {
            output = new Planar(GrayF32.class, input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertImage_MT.convertU8F32(input, output);
        } else {
            ImplConvertImage.convertU8F32(input, output);
        }
        return output;
    }

    public static Planar<GrayU8> convertF32U8(InterleavedF32 input, Planar<GrayU8> output) {
        if (output == null) {
            output = new Planar(GrayU8.class, input.width, input.height, input.numBands);
        } else {
            output.reshapeTo((ImageBase)input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertImage_MT.convertF32U8(input, output);
        } else {
            ImplConvertImage.convertF32U8(input, output);
        }
        return output;
    }

    public static InterleavedF32 convertU8F32(Planar<GrayU8> input, InterleavedF32 output) {
        if (output == null) {
            output = new InterleavedF32(input.width, input.height, input.getNumBands());
        } else {
            output.reshapeTo(input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertImage_MT.convertU8F32(input, output);
        } else {
            ImplConvertImage.convertU8F32(input, output);
        }
        return output;
    }

    public static InterleavedU8 convertF32U8(Planar<GrayF32> input, InterleavedU8 output) {
        if (output == null) {
            output = new InterleavedU8(input.width, input.height, input.getNumBands());
        } else {
            output.reshapeTo(input);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertImage_MT.convertF32U8(input, output);
        } else {
            ImplConvertImage.convertF32U8(input, output);
        }
        return output;
    }
}

