/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.encoding;

import boofcv.concurrency.BoofConcurrency;
import boofcv.core.encoding.impl.ImplConvertNV21;
import boofcv.core.encoding.impl.ImplConvertNV21_MT;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;

public class ConvertNV21 {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void nv21ToBoof(byte[] data, int width, int height, ImageBase output) {
        if (output instanceof Planar) {
            Planar pl = (Planar)output;
            if (pl.getBandType() == GrayU8.class) {
                ConvertNV21.nv21TPlanarRgb_U8(data, width, height, (Planar<GrayU8>)pl);
                return;
            } else {
                if (pl.getBandType() != GrayF32.class) throw new IllegalArgumentException("Unsupported output band format");
                ConvertNV21.nv21ToPlanarRgb_F32(data, width, height, (Planar<GrayF32>)pl);
            }
            return;
        } else if (output instanceof ImageGray) {
            if (output.getClass() == GrayU8.class) {
                ConvertNV21.nv21ToGray(data, width, height, (GrayU8)output);
                return;
            } else {
                if (output.getClass() != GrayF32.class) throw new IllegalArgumentException("Unsupported output type");
                ConvertNV21.nv21ToGray(data, width, height, (GrayF32)output);
            }
            return;
        } else {
            if (!(output instanceof ImageInterleaved)) throw new IllegalArgumentException("Boofcv image type not yet supported");
            if (output.getClass() == InterleavedU8.class) {
                ConvertNV21.nv21ToInterleaved(data, width, height, (InterleavedU8)output);
                return;
            } else {
                if (output.getClass() != InterleavedF32.class) throw new IllegalArgumentException("Unsupported output type");
                ConvertNV21.nv21ToInterleaved(data, width, height, (InterleavedF32)output);
            }
        }
    }

    public static <T extends ImageGray<T>> T nv21ToGray(byte[] data, int width, int height, T output, Class<T> outputType) {
        if (outputType == GrayU8.class) {
            return (T)ConvertNV21.nv21ToGray(data, width, height, (GrayU8)output);
        }
        if (outputType == GrayF32.class) {
            return (T)ConvertNV21.nv21ToGray(data, width, height, (GrayF32)output);
        }
        throw new IllegalArgumentException("Unsupported BoofCV Image Type " + outputType.getSimpleName());
    }

    public static GrayU8 nv21ToGray(byte[] data, int width, int height, GrayU8 output) {
        if (output != null) {
            output.reshape(width, height);
        } else {
            output = new GrayU8(width, height);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertNV21_MT.nv21ToGray(data, output);
        } else {
            ImplConvertNV21.nv21ToGray(data, output);
        }
        return output;
    }

    public static GrayF32 nv21ToGray(byte[] data, int width, int height, GrayF32 output) {
        if (output != null) {
            output.reshape(width, height);
        } else {
            output = new GrayF32(width, height);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertNV21_MT.nv21ToGray(data, output);
        } else {
            ImplConvertNV21.nv21ToGray(data, output);
        }
        return output;
    }

    public static <T extends ImageGray<T>> Planar<T> nv21ToPlanarYuv(byte[] data, int width, int height, Planar<T> output, Class<T> outputType) {
        if (outputType == GrayU8.class) {
            return ConvertNV21.nv21ToPlanarYuv_U8(data, width, height, output);
        }
        if (outputType == GrayF32.class) {
            return ConvertNV21.nv21TPlanarYuv_F32(data, width, height, output);
        }
        throw new IllegalArgumentException("Unsupported BoofCV Image Type " + outputType.getSimpleName());
    }

    public static Planar<GrayU8> nv21ToPlanarYuv_U8(byte[] data, int width, int height, Planar<GrayU8> output) {
        if (output == null) {
            output = new Planar(GrayU8.class, width, height, 3);
        } else {
            output.reshape(width, height, 3);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertNV21_MT.nv21ToPlanarYuv_U8(data, (Planar<GrayU8>)output);
        } else {
            ImplConvertNV21.nv21ToPlanarYuv_U8(data, (Planar<GrayU8>)output);
        }
        return output;
    }

    public static Planar<GrayU8> nv21TPlanarRgb_U8(byte[] data, int width, int height, Planar<GrayU8> output) {
        if (output == null) {
            output = new Planar(GrayU8.class, width, height, 3);
        } else {
            output.reshape(width, height, 3);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertNV21_MT.nv21ToPlanarRgb_U8(data, (Planar<GrayU8>)output);
        } else {
            ImplConvertNV21.nv21ToPlanarRgb_U8(data, (Planar<GrayU8>)output);
        }
        return output;
    }

    public static InterleavedU8 nv21ToInterleaved(byte[] data, int width, int height, InterleavedU8 output) {
        if (output == null) {
            output = new InterleavedU8(width, height, 3);
        } else {
            output.reshape(width, height, 3);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertNV21_MT.nv21ToInterleaved_U8(data, output);
        } else {
            ImplConvertNV21.nv21ToInterleaved_U8(data, output);
        }
        return output;
    }

    public static Planar<GrayF32> nv21TPlanarYuv_F32(byte[] data, int width, int height, Planar<GrayF32> output) {
        if (output == null) {
            output = new Planar(GrayF32.class, width, height, 3);
        } else {
            output.reshape(width, height, 3);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertNV21_MT.nv21ToPlanarYuv_F32(data, (Planar<GrayF32>)output);
        } else {
            ImplConvertNV21.nv21ToPlanarYuv_F32(data, (Planar<GrayF32>)output);
        }
        return output;
    }

    public static Planar<GrayF32> nv21ToPlanarRgb_F32(byte[] data, int width, int height, Planar<GrayF32> output) {
        if (output == null) {
            output = new Planar(GrayF32.class, width, height, 3);
        } else {
            output.reshape(width, height, 3);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertNV21_MT.nv21ToPlanarRgb_F32(data, (Planar<GrayF32>)output);
        } else {
            ImplConvertNV21.nv21ToPlanarRgb_F32(data, (Planar<GrayF32>)output);
        }
        return output;
    }

    public static InterleavedF32 nv21ToInterleaved(byte[] data, int width, int height, InterleavedF32 output) {
        if (output == null) {
            output = new InterleavedF32(width, height, 3);
        } else {
            output.reshape(width, height, 3);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplConvertNV21_MT.nv21ToInterleaved_F32(data, output);
        } else {
            ImplConvertNV21.nv21ToInterleaved_F32(data, output);
        }
        return output;
    }
}

