/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.motion;

import boofcv.abst.distort.FDistort;
import boofcv.alg.filter.kernel.KernelMath;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;

public class MotionBlurOps {
    public static Kernel2D_F32 linearMotionPsf(double lengthOfMotion, double phi) {
        int roundUp;
        int roundDown = (int)Math.floor((lengthOfMotion - 1.0) / 2.0);
        int kernelRadius = roundUp = (int)Math.ceil((lengthOfMotion - 1.0) / 2.0);
        int kernelLength = kernelRadius * 2 + 1;
        GrayF32 psfZero = new GrayF32(kernelLength, kernelLength);
        double L = lengthOfMotion;
        for (int x = -kernelRadius; x <= kernelRadius; ++x) {
            float f = Math.abs(x) <= roundDown ? (float)(1.0 / L) : (float)(1.0 / (2.0 * L) * (L - 1.0 - 2.0 * Math.floor((L - 1.0) / 2.0)));
            psfZero.set(x + kernelRadius, kernelRadius, f);
        }
        GrayF32 psf = (GrayF32)psfZero.createSameShape();
        new FDistort((ImageBase)psfZero, (ImageBase)psf).rotate(phi).apply();
        Kernel2D_F32 kernel = new Kernel2D_F32(kernelLength, kernelRadius);
        System.arraycopy(psf.data, 0, kernel.data, 0, kernelLength * kernelLength);
        if (phi != 0.0) {
            float sum = KernelMath.sum(kernel);
            KernelMath.divide(kernel, sum);
        }
        return kernel;
    }
}

