/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.impl;

import boofcv.alg.distort.ImageDistort;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.Planar;
import georegression.struct.point.Point2D_F32;

public class ImplImageDistort_PL<Input extends ImageGray<Input>, Output extends ImageGray<Output>>
implements ImageDistort<Planar<Input>, Planar<Output>> {
    ImageDistort<Input, Output> layerDistort;

    public ImplImageDistort_PL(ImageDistort<Input, Output> layerDistort) {
        this.layerDistort = layerDistort;
    }

    @Override
    public void setModel(PixelTransform<Point2D_F32> dstToSrc) {
        this.layerDistort.setModel(dstToSrc);
    }

    @Override
    public void apply(Planar<Input> srcImg, Planar<Output> dstImg) {
        if (srcImg.getNumBands() != dstImg.getNumBands()) {
            throw new IllegalArgumentException("Number of bands must be the same. " + srcImg.getNumBands() + " vs " + dstImg.getNumBands());
        }
        int N = srcImg.getNumBands();
        for (int i = 0; i < N; ++i) {
            this.layerDistort.apply(srcImg.getBand(i), dstImg.getBand(i));
        }
    }

    @Override
    public void apply(Planar<Input> srcImg, Planar<Output> dstImg, GrayU8 mask) {
        if (srcImg.getNumBands() != dstImg.getNumBands()) {
            throw new IllegalArgumentException("Number of bands must be the same. " + srcImg.getNumBands() + " vs " + dstImg.getNumBands());
        }
        int N = srcImg.getNumBands();
        for (int i = 0; i < N; ++i) {
            if (i == 0) {
                this.layerDistort.apply(srcImg.getBand(i), dstImg.getBand(i), mask);
                continue;
            }
            this.layerDistort.apply(srcImg.getBand(i), dstImg.getBand(i));
        }
    }

    @Override
    public void apply(Planar<Input> srcImg, Planar<Output> dstImg, int dstX0, int dstY0, int dstX1, int dstY1) {
        if (srcImg.getNumBands() != dstImg.getNumBands()) {
            throw new IllegalArgumentException("Number of bands must be the same. " + srcImg.getNumBands() + " vs " + dstImg.getNumBands());
        }
        int N = srcImg.getNumBands();
        for (int i = 0; i < N; ++i) {
            this.layerDistort.apply(srcImg.getBand(i), dstImg.getBand(i), dstX0, dstY0, dstX1, dstY1);
        }
    }

    @Override
    public void setRenderAll(boolean renderAll) {
        this.layerDistort.setRenderAll(renderAll);
    }

    @Override
    public boolean getRenderAll() {
        return this.layerDistort.getRenderAll();
    }

    @Override
    public PixelTransform<Point2D_F32> getModel() {
        return this.layerDistort.getModel();
    }
}

