/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.weights;

import boofcv.alg.weights.WeightDistanceSqGaussian_F32;
import boofcv.alg.weights.WeightDistanceUniform_F32;
import boofcv.alg.weights.WeightDistance_F32;
import boofcv.alg.weights.WeightPixelGaussian_F32;
import boofcv.alg.weights.WeightPixelUniform_F32;
import boofcv.alg.weights.WeightPixel_F32;
import boofcv.factory.weights.WeightType;

public class FactoryWeights {
    public static WeightDistance_F32 distance(WeightType type, float param, boolean safe) {
        if (safe) {
            throw new IllegalArgumentException("Safe distributons not implemented yet");
        }
        switch (type) {
            case GAUSSIAN_SQ: {
                return new WeightDistanceSqGaussian_F32(param);
            }
            case UNIFORM: {
                return new WeightDistanceUniform_F32(param);
            }
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    public static WeightPixel_F32 pixel(WeightType type, boolean safe) {
        if (safe) {
            throw new IllegalArgumentException("Safe distributons not implemented yet");
        }
        switch (type) {
            case GAUSSIAN_SQ: {
                return new WeightPixelGaussian_F32();
            }
            case UNIFORM: {
                return new WeightPixelUniform_F32();
            }
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }
}

