/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.transform.wavelet;

import boofcv.abst.transform.wavelet.WaveletTransform;
import boofcv.abst.transform.wavelet.impl.WaveletTransformFloat32;
import boofcv.abst.transform.wavelet.impl.WaveletTransformInt;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.ImageGray;
import boofcv.struct.wavelet.WaveletDescription;
import boofcv.struct.wavelet.WlCoef;
import boofcv.struct.wavelet.WlCoef_F32;
import boofcv.struct.wavelet.WlCoef_I32;

public class FactoryWaveletTransform {
    public static <T extends ImageGray<T>, W extends ImageGray<W>, C extends WlCoef> WaveletTransform<T, W, C> create(Class<T> imageType, WaveletDescription<C> waveletDesc, int numLevels, double minPixelValue, double maxPixelValue) {
        if (waveletDesc.getForward().getType() == Float.TYPE) {
            return FactoryWaveletTransform.create_F32(waveletDesc, numLevels, (float)minPixelValue, (float)maxPixelValue);
        }
        if (waveletDesc.getForward().getType() == Integer.TYPE) {
            return FactoryWaveletTransform.create_I(waveletDesc, numLevels, (int)minPixelValue, (int)maxPixelValue, imageType);
        }
        throw new RuntimeException("Add support for this image type");
    }

    public static <T extends GrayI<T>> WaveletTransform<T, GrayS32, WlCoef_I32> create_I(WaveletDescription<WlCoef_I32> waveletDesc, int numLevels, int minPixelValue, int maxPixelValue, Class<T> imageType) {
        return new WaveletTransformInt<T>(waveletDesc, numLevels, minPixelValue, maxPixelValue, imageType);
    }

    public static WaveletTransform<GrayF32, GrayF32, WlCoef_F32> create_F32(WaveletDescription<WlCoef_F32> waveletDesc, int numLevels, float minPixelValue, float maxPixelValue) {
        return new WaveletTransformFloat32(waveletDesc, numLevels, minPixelValue, maxPixelValue);
    }
}

