/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.interpolate.impl;

import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.NearestNeighborPixelS;
import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageType;

public class NearestNeighborPixel_F32
extends NearestNeighborPixelS<GrayF32> {
    private float[] data;

    public NearestNeighborPixel_F32() {
    }

    public NearestNeighborPixel_F32(GrayF32 orig) {
        this.setImage(orig);
    }

    @Override
    public void setImage(GrayF32 image) {
        super.setImage(image);
        this.data = ((GrayF32)this.orig).data;
    }

    @Override
    public float get_fast(float x, float y) {
        return this.data[((GrayF32)this.orig).startIndex + (int)y * this.stride + (int)x];
    }

    public float get_border(float x, float y) {
        return ((ImageBorder_F32)this.border).get((int)Math.floor(x), (int)Math.floor(y));
    }

    @Override
    public float get(float x, float y) {
        if (x < 0.0f || y < 0.0f || x > (float)(this.width - 1) || y > (float)(this.height - 1)) {
            return this.get_border(x, y);
        }
        int xx = (int)x;
        int yy = (int)y;
        return this.data[((GrayF32)this.orig).startIndex + yy * this.stride + xx];
    }

    @Override
    public InterpolatePixelS<GrayF32> copy() {
        NearestNeighborPixel_F32 out = new NearestNeighborPixel_F32();
        out.setBorder(this.border.copy());
        return out;
    }

    @Override
    public ImageType<GrayF32> getImageType() {
        return ImageType.single(GrayF32.class);
    }
}

