/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.misc.impl;

import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;

public class ImplAverageDownSample {
    public static void horizontal(GrayU8 src, GrayF32 dst) {
        if (src.width < dst.width) {
            throw new IllegalArgumentException("src width must be >= dst width");
        }
        if (src.height != dst.height) {
            throw new IllegalArgumentException("src height must equal dst height");
        }
        float scale = (float)src.width / (float)dst.width;
        for (int y = 0; y < dst.height; ++y) {
            float srcX0;
            int indexDst = dst.startIndex + y * dst.stride;
            int x = 0;
            while (x < dst.width - 1) {
                srcX0 = (float)x * scale;
                float srcX1 = (float)(x + 1) * scale;
                int isrcX0 = (int)srcX0;
                int isrcX1 = (int)srcX1;
                int index = src.getIndex(isrcX0, y);
                float startWeight = 1.0f - (srcX0 - (float)isrcX0);
                int start = src.data[index++] & 0xFF;
                int middle = 0;
                for (int i = isrcX0 + 1; i < isrcX1; ++i) {
                    middle += src.data[index++] & 0xFF;
                }
                float endWeight = srcX1 % 1.0f;
                int end = src.data[index] & 0xFF;
                dst.data[indexDst] = ((float)start * startWeight + (float)middle + (float)end * endWeight) / scale;
                ++x;
                ++indexDst;
            }
            x = dst.width - 1;
            srcX0 = (float)x * scale;
            int isrcX0 = (int)srcX0;
            int isrcX1 = src.width - 1;
            int index = src.getIndex(isrcX0, y);
            float startWeight = 1.0f - (srcX0 - (float)isrcX0);
            int start = src.data[index++] & 0xFF;
            int middle = 0;
            for (int i = isrcX0 + 1; i < isrcX1; ++i) {
                middle += src.data[index++] & 0xFF;
            }
            int end = isrcX1 != isrcX0 ? src.data[index] & 0xFF : 0;
            dst.data[indexDst] = ((float)start * startWeight + (float)middle + (float)end) / scale;
        }
    }

    public static void vertical(GrayF32 src, GrayI8 dst) {
        if (src.height < dst.height) {
            throw new IllegalArgumentException("src height must be >= dst height");
        }
        if (src.width != dst.width) {
            throw new IllegalArgumentException("src width must equal dst width");
        }
        float scale = (float)src.height / (float)dst.height;
        for (int x = 0; x < dst.width; ++x) {
            float srcY0;
            int y;
            int indexDst = dst.startIndex + x;
            for (y = 0; y < dst.height - 1; ++y) {
                srcY0 = (float)y * scale;
                float srcY1 = (float)(y + 1) * scale;
                int isrcY0 = (int)srcY0;
                int isrcY1 = (int)srcY1;
                int index = src.getIndex(x, isrcY0);
                float startWeight = 1.0f - (srcY0 - (float)isrcY0);
                float start = src.data[index];
                index += src.stride;
                float middle = 0.0f;
                for (int i = isrcY0 + 1; i < isrcY1; ++i) {
                    middle += src.data[index];
                    index += src.stride;
                }
                float endWeight = srcY1 % 1.0f;
                float end = src.data[index];
                dst.data[indexDst] = (byte)((start * startWeight + middle + end * endWeight) / scale + 0.5f);
                indexDst += dst.stride;
            }
            y = dst.height - 1;
            srcY0 = (float)y * scale;
            int isrcY0 = (int)srcY0;
            int isrcY1 = src.height - 1;
            int index = src.getIndex(x, isrcY0);
            float startWeight = 1.0f - (srcY0 - (float)isrcY0);
            float start = src.data[index];
            index += src.stride;
            float middle = 0.0f;
            for (int i = isrcY0 + 1; i < isrcY1; ++i) {
                middle += src.data[index];
                index += src.stride;
            }
            float end = isrcY1 != isrcY0 ? src.data[index] : 0.0f;
            dst.data[indexDst] = (byte)((start * startWeight + middle + end) / scale + 0.5f);
        }
    }

    public static void horizontal(GrayU16 src, GrayF32 dst) {
        if (src.width < dst.width) {
            throw new IllegalArgumentException("src width must be >= dst width");
        }
        if (src.height != dst.height) {
            throw new IllegalArgumentException("src height must equal dst height");
        }
        float scale = (float)src.width / (float)dst.width;
        for (int y = 0; y < dst.height; ++y) {
            float srcX0;
            int indexDst = dst.startIndex + y * dst.stride;
            int x = 0;
            while (x < dst.width - 1) {
                srcX0 = (float)x * scale;
                float srcX1 = (float)(x + 1) * scale;
                int isrcX0 = (int)srcX0;
                int isrcX1 = (int)srcX1;
                int index = src.getIndex(isrcX0, y);
                float startWeight = 1.0f - (srcX0 - (float)isrcX0);
                int start = src.data[index++] & 0xFFFF;
                int middle = 0;
                for (int i = isrcX0 + 1; i < isrcX1; ++i) {
                    middle += src.data[index++] & 0xFFFF;
                }
                float endWeight = srcX1 % 1.0f;
                int end = src.data[index] & 0xFFFF;
                dst.data[indexDst] = ((float)start * startWeight + (float)middle + (float)end * endWeight) / scale;
                ++x;
                ++indexDst;
            }
            x = dst.width - 1;
            srcX0 = (float)x * scale;
            int isrcX0 = (int)srcX0;
            int isrcX1 = src.width - 1;
            int index = src.getIndex(isrcX0, y);
            float startWeight = 1.0f - (srcX0 - (float)isrcX0);
            int start = src.data[index++] & 0xFFFF;
            int middle = 0;
            for (int i = isrcX0 + 1; i < isrcX1; ++i) {
                middle += src.data[index++] & 0xFFFF;
            }
            int end = isrcX1 != isrcX0 ? src.data[index] & 0xFFFF : 0;
            dst.data[indexDst] = ((float)start * startWeight + (float)middle + (float)end) / scale;
        }
    }

    public static void vertical(GrayF32 src, GrayI16 dst) {
        if (src.height < dst.height) {
            throw new IllegalArgumentException("src height must be >= dst height");
        }
        if (src.width != dst.width) {
            throw new IllegalArgumentException("src width must equal dst width");
        }
        float scale = (float)src.height / (float)dst.height;
        for (int x = 0; x < dst.width; ++x) {
            float srcY0;
            int y;
            int indexDst = dst.startIndex + x;
            for (y = 0; y < dst.height - 1; ++y) {
                srcY0 = (float)y * scale;
                float srcY1 = (float)(y + 1) * scale;
                int isrcY0 = (int)srcY0;
                int isrcY1 = (int)srcY1;
                int index = src.getIndex(x, isrcY0);
                float startWeight = 1.0f - (srcY0 - (float)isrcY0);
                float start = src.data[index];
                index += src.stride;
                float middle = 0.0f;
                for (int i = isrcY0 + 1; i < isrcY1; ++i) {
                    middle += src.data[index];
                    index += src.stride;
                }
                float endWeight = srcY1 % 1.0f;
                float end = src.data[index];
                dst.data[indexDst] = (short)((start * startWeight + middle + end * endWeight) / scale + 0.5f);
                indexDst += dst.stride;
            }
            y = dst.height - 1;
            srcY0 = (float)y * scale;
            int isrcY0 = (int)srcY0;
            int isrcY1 = src.height - 1;
            int index = src.getIndex(x, isrcY0);
            float startWeight = 1.0f - (srcY0 - (float)isrcY0);
            float start = src.data[index];
            index += src.stride;
            float middle = 0.0f;
            for (int i = isrcY0 + 1; i < isrcY1; ++i) {
                middle += src.data[index];
                index += src.stride;
            }
            float end = isrcY1 != isrcY0 ? src.data[index] : 0.0f;
            dst.data[indexDst] = (short)((start * startWeight + middle + end) / scale + 0.5f);
        }
    }

    public static void horizontal(GrayF32 src, GrayF32 dst) {
        if (src.width < dst.width) {
            throw new IllegalArgumentException("src width must be >= dst width");
        }
        if (src.height != dst.height) {
            throw new IllegalArgumentException("src height must equal dst height");
        }
        float scale = (float)src.width / (float)dst.width;
        for (int y = 0; y < dst.height; ++y) {
            float srcX0;
            int indexDst = dst.startIndex + y * dst.stride;
            int x = 0;
            while (x < dst.width - 1) {
                srcX0 = (float)x * scale;
                float srcX1 = (float)(x + 1) * scale;
                int isrcX0 = (int)srcX0;
                int isrcX1 = (int)srcX1;
                int index = src.getIndex(isrcX0, y);
                float startWeight = 1.0f - (srcX0 - (float)isrcX0);
                float start = src.data[index++];
                float middle = 0.0f;
                for (int i = isrcX0 + 1; i < isrcX1; ++i) {
                    middle += src.data[index++];
                }
                float endWeight = srcX1 % 1.0f;
                float end = src.data[index];
                dst.data[indexDst] = (start * startWeight + middle + end * endWeight) / scale;
                ++x;
                ++indexDst;
            }
            x = dst.width - 1;
            srcX0 = (float)x * scale;
            int isrcX0 = (int)srcX0;
            int isrcX1 = src.width - 1;
            int index = src.getIndex(isrcX0, y);
            float startWeight = 1.0f - (srcX0 - (float)isrcX0);
            float start = src.data[index++];
            float middle = 0.0f;
            for (int i = isrcX0 + 1; i < isrcX1; ++i) {
                middle += src.data[index++];
            }
            float end = isrcX1 != isrcX0 ? src.data[index] : 0.0f;
            dst.data[indexDst] = (start * startWeight + middle + end) / scale;
        }
    }

    public static void vertical(GrayF32 src, GrayF32 dst) {
        if (src.height < dst.height) {
            throw new IllegalArgumentException("src height must be >= dst height");
        }
        if (src.width != dst.width) {
            throw new IllegalArgumentException("src width must equal dst width");
        }
        float scale = (float)src.height / (float)dst.height;
        for (int x = 0; x < dst.width; ++x) {
            float srcY0;
            int y;
            int indexDst = dst.startIndex + x;
            for (y = 0; y < dst.height - 1; ++y) {
                srcY0 = (float)y * scale;
                float srcY1 = (float)(y + 1) * scale;
                int isrcY0 = (int)srcY0;
                int isrcY1 = (int)srcY1;
                int index = src.getIndex(x, isrcY0);
                float startWeight = 1.0f - (srcY0 - (float)isrcY0);
                float start = src.data[index];
                index += src.stride;
                float middle = 0.0f;
                for (int i = isrcY0 + 1; i < isrcY1; ++i) {
                    middle += src.data[index];
                    index += src.stride;
                }
                float endWeight = srcY1 % 1.0f;
                float end = src.data[index];
                dst.data[indexDst] = (start * startWeight + middle + end * endWeight) / scale;
                indexDst += dst.stride;
            }
            y = dst.height - 1;
            srcY0 = (float)y * scale;
            int isrcY0 = (int)srcY0;
            int isrcY1 = src.height - 1;
            int index = src.getIndex(x, isrcY0);
            float startWeight = 1.0f - (srcY0 - (float)isrcY0);
            float start = src.data[index];
            index += src.stride;
            float middle = 0.0f;
            for (int i = isrcY0 + 1; i < isrcY1; ++i) {
                middle += src.data[index];
                index += src.stride;
            }
            float end = isrcY1 != isrcY0 ? src.data[index] : 0.0f;
            dst.data[indexDst] = (start * startWeight + middle + end) / scale;
        }
    }

    public static void horizontal(GrayF64 src, GrayF64 dst) {
        if (src.width < dst.width) {
            throw new IllegalArgumentException("src width must be >= dst width");
        }
        if (src.height != dst.height) {
            throw new IllegalArgumentException("src height must equal dst height");
        }
        float scale = (float)src.width / (float)dst.width;
        for (int y = 0; y < dst.height; ++y) {
            float srcX0;
            int indexDst = dst.startIndex + y * dst.stride;
            int x = 0;
            while (x < dst.width - 1) {
                srcX0 = (float)x * scale;
                float srcX1 = (float)(x + 1) * scale;
                int isrcX0 = (int)srcX0;
                int isrcX1 = (int)srcX1;
                int index = src.getIndex(isrcX0, y);
                float startWeight = 1.0f - (srcX0 - (float)isrcX0);
                double start = src.data[index++];
                double middle = 0.0;
                for (int i = isrcX0 + 1; i < isrcX1; ++i) {
                    middle += src.data[index++];
                }
                float endWeight = srcX1 % 1.0f;
                double end = src.data[index];
                dst.data[indexDst] = (start * (double)startWeight + middle + end * (double)endWeight) / (double)scale;
                ++x;
                ++indexDst;
            }
            x = dst.width - 1;
            srcX0 = (float)x * scale;
            int isrcX0 = (int)srcX0;
            int isrcX1 = src.width - 1;
            int index = src.getIndex(isrcX0, y);
            float startWeight = 1.0f - (srcX0 - (float)isrcX0);
            double start = src.data[index++];
            double middle = 0.0;
            for (int i = isrcX0 + 1; i < isrcX1; ++i) {
                middle += src.data[index++];
            }
            double end = isrcX1 != isrcX0 ? src.data[index] : 0.0;
            dst.data[indexDst] = (start * (double)startWeight + middle + end) / (double)scale;
        }
    }

    public static void vertical(GrayF64 src, GrayF64 dst) {
        if (src.height < dst.height) {
            throw new IllegalArgumentException("src height must be >= dst height");
        }
        if (src.width != dst.width) {
            throw new IllegalArgumentException("src width must equal dst width");
        }
        float scale = (float)src.height / (float)dst.height;
        for (int x = 0; x < dst.width; ++x) {
            float srcY0;
            int y;
            int indexDst = dst.startIndex + x;
            for (y = 0; y < dst.height - 1; ++y) {
                srcY0 = (float)y * scale;
                float srcY1 = (float)(y + 1) * scale;
                int isrcY0 = (int)srcY0;
                int isrcY1 = (int)srcY1;
                int index = src.getIndex(x, isrcY0);
                float startWeight = 1.0f - (srcY0 - (float)isrcY0);
                double start = src.data[index];
                index += src.stride;
                double middle = 0.0;
                for (int i = isrcY0 + 1; i < isrcY1; ++i) {
                    middle += src.data[index];
                    index += src.stride;
                }
                float endWeight = srcY1 % 1.0f;
                double end = src.data[index];
                dst.data[indexDst] = (start * (double)startWeight + middle + end * (double)endWeight) / (double)scale;
                indexDst += dst.stride;
            }
            y = dst.height - 1;
            srcY0 = (float)y * scale;
            int isrcY0 = (int)srcY0;
            int isrcY1 = src.height - 1;
            int index = src.getIndex(x, isrcY0);
            float startWeight = 1.0f - (srcY0 - (float)isrcY0);
            double start = src.data[index];
            index += src.stride;
            double middle = 0.0;
            for (int i = isrcY0 + 1; i < isrcY1; ++i) {
                middle += src.data[index];
                index += src.stride;
            }
            double end = isrcY1 != isrcY0 ? src.data[index] : 0.0;
            dst.data[indexDst] = (start * (double)startWeight + middle + end) / (double)scale;
        }
    }
}

