/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative.impl;

import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.sparse.GradientValue_F32;
import boofcv.struct.sparse.SparseImageGradient;

public class GradientSparseThree_F32
implements SparseImageGradient<GrayF32, GradientValue_F32> {
    GrayF32 input;
    ImageBorder_F32 border;
    GradientValue_F32 gradient = new GradientValue_F32();

    public GradientSparseThree_F32(ImageBorder_F32 border) {
        this.border = border;
    }

    public GradientValue_F32 compute(int x, int y) {
        float a21;
        float a12;
        float a10;
        float a01;
        if (x >= 1 && y >= 1 && x < this.input.width - 1 && y < this.input.height - 1) {
            int s = this.input.stride;
            int tl = this.input.startIndex + this.input.stride * (y - 1) + x - 1;
            a01 = this.input.data[tl + 1];
            a10 = this.input.data[tl + s];
            a12 = this.input.data[tl + 2 + s];
            a21 = this.input.data[tl + 1 + 2 * s];
        } else {
            a01 = this.border.get(x, y - 1);
            a10 = this.border.get(x - 1, y);
            a12 = this.border.get(x + 1, y);
            a21 = this.border.get(x, y + 1);
        }
        this.gradient.y = (a21 - a01) * 0.5f;
        this.gradient.x = (a12 - a10) * 0.5f;
        return this.gradient;
    }

    public Class<GradientValue_F32> getGradientType() {
        return GradientValue_F32.class;
    }

    public void setImage(GrayF32 input) {
        this.input = input;
        if (this.border != null) {
            this.border.setImage((ImageBase)input);
        }
    }

    public boolean isInBounds(int x, int y) {
        return this.border != null || x >= 1 && y >= 1 && x < this.input.width - 1 && y < this.input.height - 1;
    }
}

