/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.color;

import boofcv.alg.color.impl.ImplColorHsv;
import boofcv.alg.color.impl.ImplColorHsv_MT;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.Planar;

public class ColorHsv {
    public static final double d60_F64 = 1.0471975511965976;
    public static final float d60_F32 = 1.0471976f;
    public static final double PI2_F64 = Math.PI * 2;
    public static final float PI2_F32 = (float)Math.PI * 2;

    public static int hsvToRgb(double h, double s, double v) {
        int r;
        int g;
        int b;
        if (s == 0.0) {
            g = b = (int)(v + 0.5);
            r = b;
        } else {
            int h_int = (int)(h /= 1.0471975511965976);
            double remainder = h - (double)h_int;
            double p = v * (1.0 - s) + 0.5;
            double q = v * (1.0 - s * remainder) + 0.5;
            double t = v * (1.0 - s * (1.0 - remainder)) + 0.5;
            if (h_int < 1) {
                r = (int)v;
                g = (int)t;
                b = (int)p;
            } else if (h_int < 2) {
                r = (int)q;
                g = (int)v;
                b = (int)p;
            } else if (h_int < 3) {
                r = (int)p;
                g = (int)v;
                b = (int)t;
            } else if (h_int < 4) {
                r = (int)p;
                g = (int)q;
                b = (int)v;
            } else if (h_int < 5) {
                r = (int)t;
                g = (int)p;
                b = (int)v;
            } else {
                r = (int)v;
                g = (int)p;
                b = (int)q;
            }
        }
        return r << 16 | g << 8 | b;
    }

    public static void hsvToRgb(double h, double s, double v, double[] rgb) {
        if (s == 0.0) {
            rgb[0] = v;
            rgb[1] = v;
            rgb[2] = v;
            return;
        }
        int h_int = (int)(h /= 1.0471975511965976);
        double remainder = h - (double)h_int;
        double p = v * (1.0 - s);
        double q = v * (1.0 - s * remainder);
        double t = v * (1.0 - s * (1.0 - remainder));
        if (h_int < 1) {
            rgb[0] = v;
            rgb[1] = t;
            rgb[2] = p;
        } else if (h_int < 2) {
            rgb[0] = q;
            rgb[1] = v;
            rgb[2] = p;
        } else if (h_int < 3) {
            rgb[0] = p;
            rgb[1] = v;
            rgb[2] = t;
        } else if (h_int < 4) {
            rgb[0] = p;
            rgb[1] = q;
            rgb[2] = v;
        } else if (h_int < 5) {
            rgb[0] = t;
            rgb[1] = p;
            rgb[2] = v;
        } else {
            rgb[0] = v;
            rgb[1] = p;
            rgb[2] = q;
        }
    }

    public static void hsvToRgb(float h, float s, float v, float[] rgb) {
        if (s == 0.0f) {
            rgb[0] = v;
            rgb[1] = v;
            rgb[2] = v;
            return;
        }
        int h_int = (int)(h /= 1.0471976f);
        float remainder = h - (float)h_int;
        float p = v * (1.0f - s);
        float q = v * (1.0f - s * remainder);
        float t = v * (1.0f - s * (1.0f - remainder));
        if (h_int < 1) {
            rgb[0] = v;
            rgb[1] = t;
            rgb[2] = p;
        } else if (h_int < 2) {
            rgb[0] = q;
            rgb[1] = v;
            rgb[2] = p;
        } else if (h_int < 3) {
            rgb[0] = p;
            rgb[1] = v;
            rgb[2] = t;
        } else if (h_int < 4) {
            rgb[0] = p;
            rgb[1] = q;
            rgb[2] = v;
        } else if (h_int < 5) {
            rgb[0] = t;
            rgb[1] = p;
            rgb[2] = v;
        } else {
            rgb[0] = v;
            rgb[1] = p;
            rgb[2] = q;
        }
    }

    public static void rgbToHsv(double r, double g, double b, double[] hsv) {
        double max;
        double d = r > g ? (r > b ? r : b) : (max = g > b ? g : b);
        double min = r < g ? (r < b ? r : b) : (g < b ? g : b);
        double delta = max - min;
        hsv[2] = max;
        if (max == 0.0) {
            hsv[0] = Double.NaN;
            hsv[1] = 0.0;
            return;
        }
        hsv[1] = delta / max;
        double h = r == max ? (g - b) / delta : (g == max ? 2.0 + (b - r) / delta : 4.0 + (r - g) / delta);
        h *= 1.0471975511965976;
        if (h < 0.0) {
            h += Math.PI * 2;
        }
        hsv[0] = h;
    }

    public static void rgbToHsv(float r, float g, float b, float[] hsv) {
        float max;
        float f = r > g ? (r > b ? r : b) : (max = g > b ? g : b);
        float min = r < g ? (r < b ? r : b) : (g < b ? g : b);
        float delta = max - min;
        hsv[2] = max;
        if (max == 0.0f) {
            hsv[0] = Float.NaN;
            hsv[1] = 0.0f;
            return;
        }
        hsv[1] = delta / max;
        float h = r == max ? (g - b) / delta : (g == max ? 2.0f + (b - r) / delta : 4.0f + (r - g) / delta);
        h *= 1.0471976f;
        if (h < 0.0f) {
            h += (float)Math.PI * 2;
        }
        hsv[0] = h;
    }

    public static <T extends ImageGray<T>> void hsvToRgb(Planar<T> hsv, Planar<T> rgb) {
        rgb.reshape(hsv.width, hsv.height, 3);
        if (hsv.getBandType() == GrayF32.class) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplColorHsv_MT.hsvToRgb_F32(hsv, rgb);
            } else {
                ImplColorHsv.hsvToRgb_F32(hsv, rgb);
            }
        } else {
            throw new IllegalArgumentException("Unsupported band type " + hsv.getBandType().getSimpleName());
        }
    }

    public static <T extends ImageGray<T>> void rgbToHsv(Planar<T> rgb, Planar<T> hsv) {
        hsv.reshape(rgb.width, rgb.height, 3);
        if (hsv.getBandType() == GrayF32.class) {
            if (BoofConcurrency.USE_CONCURRENT) {
                ImplColorHsv_MT.rgbToHsv_F32(rgb, hsv);
            } else {
                ImplColorHsv.rgbToHsv_F32(rgb, hsv);
            }
        } else {
            throw new IllegalArgumentException("Unsupported band type " + hsv.getBandType().getSimpleName());
        }
    }
}

