/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.binary;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.core.image.GConvertImage;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import org.jetbrains.annotations.Nullable;

public class InputToBinarySwitch<T extends ImageGray<T>>
implements InputToBinary<T> {
    ImageType<T> inputType;
    InputToBinary alg;
    @Nullable
    ImageGray work;

    public InputToBinarySwitch(InputToBinary alg, Class<T> inputType) {
        this.alg = alg;
        this.inputType = ImageType.single(inputType);
        if (!alg.getInputType().isSameType(this.inputType)) {
            this.work = (ImageGray)alg.getInputType().createImage(1, 1);
        }
    }

    @Override
    public void process(T input, GrayU8 output) {
        output.reshape(input);
        if (this.work == null) {
            this.alg.process(input, output);
        } else {
            this.work.reshape(input);
            GConvertImage.convert(input, (ImageBase)this.work);
            this.alg.process(this.work, output);
        }
    }

    @Override
    public ImageType<T> getInputType() {
        return this.inputType;
    }
}

