/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.pyramid;

import boofcv.abst.distort.FDistort;
import boofcv.alg.distort.PixelTransformAffine_F32;
import boofcv.alg.distort.impl.DistortSupport;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.pyramid.ImagePyramid;
import boofcv.struct.pyramid.PyramidFloat;

public class PyramidFloatScale<T extends ImageGray<T>>
extends PyramidFloat<T> {
    protected InterpolatePixelS<T> interpolate;

    public PyramidFloatScale(InterpolatePixelS<T> interpolate, double[] scaleFactors, Class<T> imageType) {
        super(ImageType.single(imageType), scaleFactors);
        this.interpolate = interpolate;
    }

    protected PyramidFloatScale(PyramidFloatScale<T> orig) {
        super(orig);
        this.interpolate = orig.interpolate.copy();
    }

    public void process(T input) {
        super.initialize(((ImageGray)input).width, ((ImageGray)input).height);
        if (this.isSaveOriginalReference()) {
            throw new IllegalArgumentException("The original reference cannot be saved");
        }
        FDistort distort = new FDistort(this.getImageType());
        for (int i = 0; i < this.scale.length; ++i) {
            T prev = i == 0 ? input : (ImageGray)this.getLayer(i - 1);
            ImageGray layer = (ImageGray)this.getLayer(i);
            PixelTransformAffine_F32 model = DistortSupport.transformScale((ImageBase)layer, prev, null);
            distort.setRefs((ImageBase)prev, (ImageBase)layer).transform(model).interp(this.interpolate).apply();
        }
    }

    public double getSampleOffset(int layer) {
        return 0.0;
    }

    public double getSigma(int layer) {
        return 0.0;
    }

    public ImagePyramid<T> copyStructure() {
        return new PyramidFloatScale<T>(this);
    }
}

