/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary.impl;

import boofcv.struct.image.GrayU8;

public class ImplBinaryInnerOps {
    public static void erode4(GrayU8 input, GrayU8 output) {
        int h = input.height - 1;
        int w = input.width - 2;
        for (int y = 1; y < h; ++y) {
            int indexIn = input.startIndex + y * input.stride + 1;
            int indexOut = output.startIndex + y * output.stride + 1;
            int end = indexIn + w;
            while (indexIn < end) {
                output.data[indexOut] = input.data[indexIn] + input.data[indexIn - 1] + input.data[indexIn + 1] + input.data[indexIn - input.stride] + input.data[indexIn + input.stride] == 5 ? (byte)1 : 0;
                ++indexIn;
                ++indexOut;
            }
        }
    }

    public static void dilate4(GrayU8 input, GrayU8 output) {
        int h = input.height - 1;
        int w = input.width - 2;
        for (int y = 1; y < h; ++y) {
            int indexIn = input.startIndex + y * input.stride + 1;
            int indexOut = output.startIndex + y * output.stride + 1;
            int end = indexIn + w;
            while (indexIn < end) {
                output.data[indexOut] = input.data[indexIn] + input.data[indexIn - 1] + input.data[indexIn + 1] + input.data[indexIn - input.stride] + input.data[indexIn + input.stride] > 0 ? (byte)1 : 0;
                ++indexIn;
                ++indexOut;
            }
        }
    }

    public static void edge4(GrayU8 input, GrayU8 output) {
        int h = input.height - 1;
        int w = input.width - 2;
        for (int y = 1; y < h; ++y) {
            int indexIn = input.startIndex + y * input.stride + 1;
            int indexOut = output.startIndex + y * output.stride + 1;
            int end = indexIn + w;
            while (indexIn < end) {
                output.data[indexOut] = input.data[indexIn - 1] + input.data[indexIn + 1] + input.data[indexIn - input.stride] + input.data[indexIn + input.stride] == 4 ? (byte)0 : input.data[indexIn];
                ++indexIn;
                ++indexOut;
            }
        }
    }

    public static void erode8(GrayU8 input, GrayU8 output) {
        int h = input.height - 1;
        int w = input.width - 2;
        for (int y = 1; y < h; ++y) {
            int indexIn = input.startIndex + y * input.stride + 1;
            int indexOut = output.startIndex + y * output.stride + 1;
            int end = indexIn + w;
            while (indexIn < end) {
                output.data[indexOut] = input.data[indexIn] + input.data[indexIn - 1] + input.data[indexIn + 1] + input.data[indexIn + input.stride - 1] + input.data[indexIn + input.stride] + input.data[indexIn + input.stride + 1] + input.data[indexIn - input.stride - 1] + input.data[indexIn - input.stride] + input.data[indexIn - input.stride + 1] == 9 ? (byte)1 : 0;
                ++indexIn;
                ++indexOut;
            }
        }
    }

    public static void dilate8(GrayU8 input, GrayU8 output) {
        int h = input.height - 1;
        int w = input.width - 2;
        for (int y = 1; y < h; ++y) {
            int indexIn = input.startIndex + y * input.stride + 1;
            int indexOut = output.startIndex + y * output.stride + 1;
            int end = indexIn + w;
            while (indexIn < end) {
                output.data[indexOut] = input.data[indexIn] + input.data[indexIn - 1] + input.data[indexIn + 1] + input.data[indexIn + input.stride - 1] + input.data[indexIn + input.stride] + input.data[indexIn + input.stride + 1] + input.data[indexIn - input.stride - 1] + input.data[indexIn - input.stride] + input.data[indexIn - input.stride + 1] > 0 ? (byte)1 : 0;
                ++indexIn;
                ++indexOut;
            }
        }
    }

    public static void edge8(GrayU8 input, GrayU8 output) {
        int h = input.height - 1;
        int w = input.width - 2;
        for (int y = 1; y < h; ++y) {
            int indexIn = input.startIndex + y * input.stride + 1;
            int indexOut = output.startIndex + y * output.stride + 1;
            int end = indexIn + w;
            while (indexIn < end) {
                output.data[indexOut] = input.data[indexIn - 1] + input.data[indexIn + 1] + input.data[indexIn + input.stride - 1] + input.data[indexIn + input.stride] + input.data[indexIn + input.stride + 1] + input.data[indexIn - input.stride - 1] + input.data[indexIn - input.stride] + input.data[indexIn - input.stride + 1] == 8 ? (byte)0 : input.data[indexIn];
                ++indexIn;
                ++indexOut;
            }
        }
    }

    public static void removePointNoise(GrayU8 input, GrayU8 output) {
        int h = input.height - 1;
        int w = input.width - 2;
        for (int y = 1; y < h; ++y) {
            int indexIn = input.startIndex + y * input.stride + 1;
            int indexOut = output.startIndex + y * output.stride + 1;
            int end = indexIn + w;
            while (indexIn < end) {
                int total = input.data[indexIn - 1] + input.data[indexIn + 1] + input.data[indexIn + input.stride - 1] + input.data[indexIn + input.stride] + input.data[indexIn + input.stride + 1] + input.data[indexIn - input.stride - 1] + input.data[indexIn - input.stride] + input.data[indexIn - input.stride + 1];
                output.data[indexOut] = total < 2 ? (byte)0 : (total > 6 ? (byte)1 : input.data[indexIn]);
                ++indexIn;
                ++indexOut;
            }
        }
    }
}

