/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary;

import georegression.struct.point.Point2D_I32;
import java.util.List;

public class ContourOps {
    public static boolean isEquivalent(List<Point2D_I32> contourA, List<Point2D_I32> contourB) {
        if (contourA.size() != contourB.size()) {
            return false;
        }
        if (contourA.size() == 0) {
            return true;
        }
        int N = contourA.size();
        Point2D_I32 first = contourA.get(0);
        for (int i = 0; i < N; ++i) {
            if (!contourB.get(i).equals((Object)first)) continue;
            boolean success = true;
            for (int j = 1; j < N; ++j) {
                int indexB = (j + i) % N;
                if (contourA.get(j).equals((Object)contourB.get(indexB))) continue;
                success = false;
                break;
            }
            if (!success) continue;
            return true;
        }
        return false;
    }

    public static boolean isTouchBorder(List<Point2D_I32> contour, int width, int height) {
        int w = width - 1;
        int h = height - 1;
        for (int j = 0; j < contour.size(); ++j) {
            Point2D_I32 p = contour.get(j);
            if (p.x != 0 && p.y != 0 && p.x != w && p.y != h) continue;
            return true;
        }
        return false;
    }
}

