/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.color.impl;

import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.Planar;

public class ImplColorHsv_MT {
    public static void hsvToRgb_F32(Planar<GrayF32> hsv, Planar<GrayF32> rgb) {
        GrayF32 H = (GrayF32)hsv.getBand(0);
        GrayF32 S = (GrayF32)hsv.getBand(1);
        GrayF32 V = (GrayF32)hsv.getBand(2);
        GrayF32 R = (GrayF32)rgb.getBand(0);
        GrayF32 G = (GrayF32)rgb.getBand(1);
        GrayF32 B = (GrayF32)rgb.getBand(2);
        BoofConcurrency.loopFor((int)0, (int)hsv.height, row -> {
            int indexRgb;
            int indexHsv = hsv.startIndex + row * hsv.stride;
            int endRgb = indexRgb + hsv.width;
            for (indexRgb = rgb.startIndex + row * rgb.stride; indexRgb < endRgb; ++indexRgb) {
                float h = H.data[indexHsv];
                float s = S.data[indexHsv];
                float v = V.data[indexHsv];
                if (s == 0.0f) {
                    R.data[indexRgb] = v;
                    G.data[indexRgb] = v;
                    B.data[indexRgb] = v;
                } else {
                    int h_int = (int)(h /= 1.0471976f);
                    float remainder = h - (float)h_int;
                    float p = v * (1.0f - s);
                    float q = v * (1.0f - s * remainder);
                    float t = v * (1.0f - s * (1.0f - remainder));
                    if (h_int < 1) {
                        R.data[indexRgb] = v;
                        G.data[indexRgb] = t;
                        B.data[indexRgb] = p;
                    } else if (h_int < 2) {
                        R.data[indexRgb] = q;
                        G.data[indexRgb] = v;
                        B.data[indexRgb] = p;
                    } else if (h_int < 3) {
                        R.data[indexRgb] = p;
                        G.data[indexRgb] = v;
                        B.data[indexRgb] = t;
                    } else if (h_int < 4) {
                        R.data[indexRgb] = p;
                        G.data[indexRgb] = q;
                        B.data[indexRgb] = v;
                    } else if (h_int < 5) {
                        R.data[indexRgb] = t;
                        G.data[indexRgb] = p;
                        B.data[indexRgb] = v;
                    } else {
                        R.data[indexRgb] = v;
                        G.data[indexRgb] = p;
                        B.data[indexRgb] = q;
                    }
                }
                ++indexHsv;
            }
        });
    }

    public static void rgbToHsv_F32(Planar<GrayF32> rgb, Planar<GrayF32> hsv) {
        GrayF32 R = (GrayF32)rgb.getBand(0);
        GrayF32 G = (GrayF32)rgb.getBand(1);
        GrayF32 B = (GrayF32)rgb.getBand(2);
        GrayF32 H = (GrayF32)hsv.getBand(0);
        GrayF32 S = (GrayF32)hsv.getBand(1);
        GrayF32 V = (GrayF32)hsv.getBand(2);
        BoofConcurrency.loopFor((int)0, (int)hsv.height, row -> {
            int indexRgb;
            int indexHsv = hsv.startIndex + row * hsv.stride;
            int endRgb = indexRgb + hsv.width;
            for (indexRgb = rgb.startIndex + row * rgb.stride; indexRgb < endRgb; ++indexRgb) {
                float max;
                float r = R.data[indexRgb];
                float g = G.data[indexRgb];
                float b = B.data[indexRgb];
                float f = r > g ? (r > b ? r : b) : (max = g > b ? g : b);
                float min = r < g ? (r < b ? r : b) : (g < b ? g : b);
                float delta = max - min;
                V.data[indexHsv] = max;
                if (max == 0.0f) {
                    H.data[indexHsv] = Float.NaN;
                    S.data[indexHsv] = 0.0f;
                } else {
                    S.data[indexHsv] = delta / max;
                    float h = r == max ? (g - b) / delta : (g == max ? 2.0f + (b - r) / delta : 4.0f + (r - g) / delta);
                    h *= 1.0471976f;
                    if (h < 0.0f) {
                        h += (float)Math.PI * 2;
                    }
                    H.data[indexHsv] = h;
                }
                ++indexHsv;
            }
        });
    }
}

