/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.derivative;

import boofcv.abst.filter.derivative.GradientMultiToSingleBand;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.struct.border.BorderType;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.ImageType;

public class ImageGradientThenReduce<Input extends ImageMultiBand<Input>, Middle extends ImageMultiBand<Middle>, Output extends ImageGray<Output>>
implements ImageGradient<Input, Output> {
    ImageGradient<Input, Middle> gradient;
    GradientMultiToSingleBand<Middle, Output> reduce;
    Middle middleX;
    Middle middleY;

    public ImageGradientThenReduce(ImageGradient<Input, Middle> gradient, GradientMultiToSingleBand<Middle, Output> reduce) {
        this.gradient = gradient;
        this.reduce = reduce;
        this.middleX = (ImageMultiBand)gradient.getDerivativeType().createImage(1, 1);
        this.middleY = (ImageMultiBand)gradient.getDerivativeType().createImage(1, 1);
    }

    @Override
    public void setBorderType(BorderType type) {
        this.gradient.setBorderType(type);
    }

    @Override
    public BorderType getBorderType() {
        return this.gradient.getBorderType();
    }

    @Override
    public int getBorder() {
        return this.gradient.getBorder();
    }

    @Override
    public ImageType<Output> getDerivativeType() {
        return ImageType.single(this.reduce.getOutputType());
    }

    @Override
    public void process(Input inputImage, Output derivX, Output derivY) {
        this.middleX.reshape(((ImageMultiBand)inputImage).width, ((ImageMultiBand)inputImage).height);
        this.middleY.reshape(((ImageMultiBand)inputImage).width, ((ImageMultiBand)inputImage).height);
        this.gradient.process(inputImage, this.middleX, this.middleY);
        this.reduce.process(this.middleX, this.middleY, derivX, derivY);
    }

    @Override
    public ImageType<Input> getInputType() {
        return this.gradient.getInputType();
    }
}

