/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.mvs.impl;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.rectify.DisparityParameters;
import boofcv.misc.BoofLambdas;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import georegression.struct.point.Point2D_F64;

public class ImplMultiViewStereoOps {
    public static void disparityToCloud(GrayF32 disparity, DisparityParameters parameters, BoofLambdas.PixXyzConsumer_F64 consumer) {
        CameraPinhole intrinsic = parameters.pinhole;
        double baseline = parameters.baseline;
        double disparityMin = parameters.disparityMin;
        double[] R = parameters.rotateToRectified.data;
        Point2D_F64 norm = new Point2D_F64();
        for (int pixY = 0; pixY < disparity.height; ++pixY) {
            int indexDisp = disparity.startIndex + pixY * disparity.stride;
            int pixX = 0;
            while (pixX < disparity.width) {
                float d = disparity.data[indexDisp];
                if (!(d >= (float)parameters.disparityRange)) {
                    PerspectiveOps.convertPixelToNorm((CameraPinhole)intrinsic, (double)pixX, (double)pixY, (Point2D_F64)norm);
                    double Z = baseline * intrinsic.fx / ((double)d + disparityMin);
                    double X = Z * norm.x;
                    double Y = Z * norm.y;
                    double outX = R[0] * X + R[3] * Y + R[6] * Z;
                    double outY = R[1] * X + R[4] * Y + R[7] * Z;
                    double outZ = R[2] * X + R[5] * Y + R[8] * Z;
                    consumer.process(pixX, pixY, outX, outY, outZ);
                }
                ++pixX;
                ++indexDisp;
            }
        }
    }

    public static void disparityToCloud(GrayF32 disparity, DisparityParameters parameters, PixelTransform<Point2D_F64> pixelToNorm, BoofLambdas.PixXyzConsumer_F64 consumer) {
        CameraPinhole intrinsic = parameters.pinhole;
        double baseline = parameters.baseline;
        double disparityMin = parameters.disparityMin;
        double[] R = parameters.rotateToRectified.data;
        Point2D_F64 norm = new Point2D_F64();
        for (int pixY = 0; pixY < disparity.height; ++pixY) {
            int indexDisp = disparity.startIndex + pixY * disparity.stride;
            int pixX = 0;
            while (pixX < disparity.width) {
                float d = disparity.data[indexDisp];
                if (!(d >= (float)parameters.disparityRange)) {
                    pixelToNorm.compute(pixX, pixY, (Object)norm);
                    double Z = baseline * intrinsic.fx / ((double)d + disparityMin);
                    double X = Z * norm.x;
                    double Y = Z * norm.y;
                    double outX = R[0] * X + R[3] * Y + R[6] * Z;
                    double outY = R[1] * X + R[4] * Y + R[7] * Z;
                    double outZ = R[2] * X + R[5] * Y + R[8] * Z;
                    consumer.process(pixX, pixY, outX, outY, outZ);
                }
                ++pixX;
                ++indexDisp;
            }
        }
    }

    public static void disparityToCloud(GrayU8 disparity, DisparityParameters parameters, PixelTransform<Point2D_F64> pixelToNorm, BoofLambdas.PixXyzConsumer_F64 consumer) {
        CameraPinhole intrinsic = parameters.pinhole;
        double baseline = parameters.baseline;
        double disparityMin = parameters.disparityMin;
        double[] R = parameters.rotateToRectified.data;
        Point2D_F64 norm = new Point2D_F64();
        for (int pixY = 0; pixY < disparity.height; ++pixY) {
            int indexDisp = disparity.startIndex + pixY * disparity.stride;
            int pixX = 0;
            while (pixX < disparity.width) {
                int d = disparity.data[indexDisp] & 0xFF;
                if (d < parameters.disparityRange) {
                    pixelToNorm.compute(pixX, pixY, (Object)norm);
                    double Z = baseline * intrinsic.fx / ((double)d + disparityMin);
                    double X = Z * norm.x;
                    double Y = Z * norm.y;
                    double outX = R[0] * X + R[3] * Y + R[6] * Z;
                    double outY = R[1] * X + R[4] * Y + R[7] * Z;
                    double outZ = R[2] * X + R[5] * Y + R[8] * Z;
                    consumer.process(pixX, pixY, outX, outY, outZ);
                }
                ++pixX;
                ++indexDisp;
            }
        }
    }

    public static void inverseToCloud(GrayF32 inverseDepthImage, PixelTransform<Point2D_F64> pixelToNorm, BoofLambdas.PixXyzConsumer_F64 consumer) {
        Point2D_F64 norm = new Point2D_F64();
        for (int pixY = 0; pixY < inverseDepthImage.height; ++pixY) {
            int indexDisp = inverseDepthImage.startIndex + pixY * inverseDepthImage.stride;
            int pixX = 0;
            while (pixX < inverseDepthImage.width) {
                float inv = inverseDepthImage.data[indexDisp];
                if (!(inv <= 0.0f)) {
                    pixelToNorm.compute(pixX, pixY, (Object)norm);
                    double X = norm.x / (double)inv;
                    double Y = norm.y / (double)inv;
                    double Z = 1.0 / (double)inv;
                    consumer.process(pixX, pixY, X, Y, Z);
                }
                ++pixX;
                ++indexDisp;
            }
        }
    }

    public static float averageScore(GrayU8 disparity, int disparityRange, GrayF32 score) {
        InputSanityCheck.checkSameShape((ImageBase)disparity, (ImageBase)score);
        float sum = 0.0f;
        int count = 0;
        for (int y = 0; y < disparity.height; ++y) {
            int indexDisp = disparity.startIndex + y * disparity.stride;
            int indexScor = score.startIndex + y * score.stride;
            int end = indexDisp + disparity.width;
            while (indexDisp < end) {
                int d = disparity.data[indexDisp++] & 0xFF;
                float s = score.data[indexScor++];
                if (d >= disparityRange) continue;
                sum += s;
                ++count;
            }
        }
        return sum / (float)count;
    }

    public static float averageScore(GrayF32 disparity, float disparityRange, GrayF32 score) {
        InputSanityCheck.checkSameShape((ImageBase)disparity, (ImageBase)score);
        float sum = 0.0f;
        int count = 0;
        for (int y = 0; y < disparity.height; ++y) {
            int indexDisp = disparity.startIndex + y * disparity.stride;
            int indexScor = score.startIndex + y * score.stride;
            int end = indexDisp + disparity.width;
            while (indexDisp < end) {
                float d = disparity.data[indexDisp++];
                float s = score.data[indexScor++];
                if (d >= disparityRange) continue;
                sum += s;
                ++count;
            }
        }
        return sum / (float)count;
    }

    public static void invalidateUsingError(GrayU8 disparity, int disparityRange, GrayF32 score, float threshold) {
        InputSanityCheck.checkSameShape((ImageBase)disparity, (ImageBase)score);
        for (int y = 0; y < disparity.height; ++y) {
            int indexDisp;
            int indexScor = score.startIndex + y * score.stride;
            int end = indexDisp + disparity.width;
            for (indexDisp = disparity.startIndex + y * disparity.stride; indexDisp < end; ++indexDisp) {
                int n = indexScor++;
                float s = score.data[n];
                if (!(s > threshold)) continue;
                disparity.data[indexDisp] = (byte)disparityRange;
            }
        }
    }

    public static void invalidateUsingError(GrayF32 disparity, float disparityRange, GrayF32 score, float threshold) {
        InputSanityCheck.checkSameShape((ImageBase)disparity, (ImageBase)score);
        for (int y = 0; y < disparity.height; ++y) {
            int indexDisp;
            int indexScor = score.startIndex + y * score.stride;
            int end = indexDisp + disparity.width;
            for (indexDisp = disparity.startIndex + y * disparity.stride; indexDisp < end; ++indexDisp) {
                int n = indexScor++;
                float s = score.data[n];
                if (!(s > threshold)) continue;
                disparity.data[indexDisp] = disparityRange;
            }
        }
    }
}

