/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.mvs;

import boofcv.alg.misc.GImageMiscOps;
import boofcv.alg.mvs.MultiViewStereoOps;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;

public class CreateCloudFromDisparityImages {
    public double disparitySimilarTol = 1.0;
    final DogArray<Point3D_F64> cloud = new DogArray(Point3D_F64::new, p -> p.setTo(0.0, 0.0, 0.0));
    final DogArray_I32 viewPointIdx = new DogArray_I32();
    final GrayU8 duplicateMask = new GrayU8(1, 1);

    public void reset() {
        this.cloud.reset();
        this.viewPointIdx.reset();
        this.viewPointIdx.add(0);
    }

    public int addCloud(List<Point3D_F64> cloud) {
        this.viewPointIdx.add(this.cloud.size + cloud.size());
        this.cloud.copyAll(cloud, (s, d) -> d.setTo(s));
        return this.viewPointIdx.size - 1;
    }

    public int addInverseDepth(GrayF32 inverseDepth, Se3_F64 world_to_view, Point2Transform2_F64 norm_to_pixel, PixelTransform<Point2D_F64> pixel_to_norm) {
        this.duplicateMask.reshape((ImageBase)inverseDepth);
        GImageMiscOps.fill((ImageBase)this.duplicateMask, (double)0.0);
        MultiViewStereoOps.maskOutPointsInCloud(this.cloud.toList(), inverseDepth, world_to_view, norm_to_pixel, this.disparitySimilarTol, this.duplicateMask);
        Point2D_F64 norm = new Point2D_F64();
        Point3D_F64 camP = new Point3D_F64();
        for (int y = 0; y < inverseDepth.height; ++y) {
            int indexDisp = y * inverseDepth.stride + inverseDepth.startIndex;
            int indexMask = y * this.duplicateMask.stride + this.duplicateMask.startIndex;
            int x = 0;
            while (x < inverseDepth.width) {
                float inv;
                if (this.duplicateMask.data[indexMask] == 0 && !((double)(inv = inverseDepth.data[indexDisp]) <= 0.0)) {
                    pixel_to_norm.compute(x, y, (Object)norm);
                    camP.x = norm.x / (double)inv;
                    camP.y = norm.y / (double)inv;
                    camP.z = 1.0 / (double)inv;
                    SePointOps_F64.transformReverse((Se3_F64)world_to_view, (Point3D_F64)camP, (Point3D_F64)((Point3D_F64)this.cloud.grow()));
                }
                ++x;
                ++indexDisp;
                ++indexMask;
            }
        }
        this.viewPointIdx.add(this.cloud.size());
        return this.viewPointIdx.size - 1;
    }

    public DogArray<Point3D_F64> getCloud() {
        return this.cloud;
    }

    public DogArray_I32 getViewPointIdx() {
        return this.viewPointIdx;
    }
}

